/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.CraftingProxyBlock;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.integration.appeng.blockentity.AECraftingProxyBlockEntity;
import thelm.packagedauto.inventory.CraftingProxyItemHandler;
import thelm.packagedauto.item.ProxyMarkerItem;
import thelm.packagedauto.menu.CraftingProxyMenu;
import thelm.packagedauto.network.packet.BeamPacket;
import thelm.packagedauto.network.packet.DirectionalMarkerPacket;
import thelm.packagedauto.network.packet.SizedMarkerPacket;
import thelm.packagedauto.util.MiscHelper;

public class CraftingProxyBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine,
ISettingsCloneable {
    public static final BlockEntityType<CraftingProxyBlockEntity> TYPE_INSTANCE = (BlockEntityType)BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)((BlockEntityType.BlockEntitySupplier)MiscHelper.INSTANCE.conditionalSupplier(() -> ModList.get().isLoaded("ae2"), () -> () -> AECraftingProxyBlockEntity::new, () -> () -> CraftingProxyBlockEntity::new).get()), (Block[])new Block[]{CraftingProxyBlock.INSTANCE}).m_58966_(null).setRegistryName("packagedauto:crafting_proxy");
    public static int range = 8;
    public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60L, TimeUnit.SECONDS).build();
    public DirectionalGlobalPos target;

    public CraftingProxyBlockEntity(BlockPos pos, BlockState state) {
        super(TYPE_INSTANCE, pos, state);
        this.setItemHandler(new CraftingProxyItemHandler(this));
    }

    @Override
    protected Component getDefaultName() {
        return new TranslatableComponent("block.packagedauto.crafting_proxy");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.crafting_proxy";
    }

    @Override
    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        IPackageCraftingMachine machine;
        if (!this.isBusy() && (machine = (IPackageCraftingMachine)this.f_58857_.m_7702_(this.target.blockPos())).acceptPackage(recipeInfo, stacks, this.target.direction())) {
            Direction dir = this.target.direction();
            Vec3 source = Vec3.m_82512_((Vec3i)this.f_58858_);
            Vec3 delta = Vec3.m_82528_((Vec3i)this.target.blockPos().m_141950_((Vec3i)this.f_58858_)).m_82549_(Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82490_(0.5));
            BeamPacket.sendBeams(source, List.of(delta), 0xFF7F00, 6, true, (ResourceKey<Level>)this.f_58857_.m_46472_(), 32.0);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBusy() {
        if (this.target == null) {
            return true;
        }
        BlockPos pos = this.target.blockPos();
        if (!this.f_58857_.m_46749_(pos)) {
            return true;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
        if (blockEntity != null && !(blockEntity instanceof CraftingProxyBlockEntity) && blockEntity instanceof IPackageCraftingMachine) {
            IPackageCraftingMachine machine = (IPackageCraftingMachine)blockEntity;
            return machine.isBusy();
        }
        return true;
    }

    public void sendPreview(ServerPlayer player) {
        long currentTime = this.f_58857_.m_46467_();
        Long cachedTime = (Long)this.previewTimes.getIfPresent((Object)player.m_142081_());
        if (cachedTime == null || currentTime - cachedTime > 180L) {
            if (this.target != null) {
                Direction dir = this.target.direction();
                Vec3 source = Vec3.m_82512_((Vec3i)this.f_58858_);
                Vec3 delta = Vec3.m_82528_((Vec3i)this.target.blockPos().m_141950_((Vec3i)this.f_58858_)).m_82549_(Vec3.m_82528_((Vec3i)dir.m_122436_()).m_82490_(0.5));
                DirectionalMarkerPacket.sendDirectionalMarkers(player, List.of(this.target), 0xFFFF00, 200);
                BeamPacket.sendBeams(player, source, List.of(delta), 0xFFFF00, 200, false);
            }
            Vec3 lowerCorner = Vec3.m_82528_((Vec3i)this.f_58858_).m_82492_((double)range, (double)range, (double)range);
            Vec3 size = new Vec3((double)(range * 2 + 1), (double)(range * 2 + 1), (double)(range * 2 + 1));
            SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 0xFF7F00, 200);
        }
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
        ItemStack stack;
        Inventory playerInventory;
        block12: {
            if (!nbt.m_128441_("Target")) {
                return ISettingsCloneable.Result.fail((Component)new TranslatableComponent("item.packagedauto.settings_cloner.invalid"));
            }
            int availableCount = 0;
            playerInventory = player.m_150109_();
            if (!this.itemHandler.getStackInSlot(0).m_41619_()) {
                if (this.itemHandler.getStackInSlot(0).m_150930_((Item)ProxyMarkerItem.INSTANCE)) {
                    availableCount += this.itemHandler.getStackInSlot(0).m_41613_();
                } else {
                    return ISettingsCloneable.Result.fail((Component)new TranslatableComponent("block.packagedauto.crafting_proxy.non_marker_present"));
                }
            }
            if (availableCount < 1) {
                for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                    stack = playerInventory.m_8020_(i);
                    if (!stack.m_41619_() && stack.m_150930_((Item)ProxyMarkerItem.INSTANCE) && !stack.m_41782_()) {
                        availableCount += stack.m_41613_();
                    }
                    if (availableCount < 1) {
                        continue;
                    }
                    break block12;
                }
                return ISettingsCloneable.Result.fail((Component)new TranslatableComponent("block.packagedauto.crafting_proxy.no_markers"));
            }
        }
        int removedCount = this.itemHandler.getStackInSlot(0).m_41613_();
        this.itemHandler.setStackInSlot(0, ItemStack.f_41583_);
        if (removedCount < 1) {
            for (int i = 0; i < playerInventory.m_6643_(); ++i) {
                ItemStack stack2 = playerInventory.m_8020_(i);
                if (!stack2.m_41619_() && stack2.m_150930_((Item)ProxyMarkerItem.INSTANCE) && !stack2.m_41782_()) {
                    removedCount += stack2.m_41620_(1).m_41613_();
                }
                if (removedCount >= 1) break;
            }
        }
        if (removedCount > 1 && !playerInventory.m_36054_(stack = new ItemStack((ItemLike)ProxyMarkerItem.INSTANCE, removedCount - 1))) {
            ItemEntity item = new ItemEntity(this.f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
            item.m_32052_(player.m_142081_());
            this.f_58857_.m_7967_((Entity)item);
        }
        CompoundTag targetTag = nbt.m_128469_("Target");
        ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(targetTag.m_128461_("Dimension")));
        int[] posArray = targetTag.m_128465_("Position");
        BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
        Direction direction = Direction.m_122376_((int)targetTag.m_128445_("Direction"));
        DirectionalGlobalPos globalPos = new DirectionalGlobalPos((ResourceKey<Level>)dimension, blockPos, direction);
        ItemStack stack3 = new ItemStack((ItemLike)ProxyMarkerItem.INSTANCE);
        ProxyMarkerItem.INSTANCE.setDirectionalGlobalPos(stack3, globalPos);
        this.itemHandler.setStackInSlot(0, stack3);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
        if (this.target == null) {
            return ISettingsCloneable.Result.fail((Component)new TranslatableComponent("block.packagedauto.crafting_proxy.empty"));
        }
        CompoundTag targetTag = new CompoundTag();
        targetTag.m_128359_("Dimension", this.target.dimension().m_135782_().toString());
        targetTag.m_128385_("Position", new int[]{this.target.x(), this.target.y(), this.target.z()});
        targetTag.m_128344_("Direction", (byte)this.target.direction().m_122411_());
        nbt.m_128365_("Target", (Tag)targetTag);
        return ISettingsCloneable.Result.success();
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new CraftingProxyMenu(windowId, inventory, this);
    }
}

