/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class StackFluidHandlerItem
implements IFluidHandlerItem {
    protected ItemStack container;

    public StackFluidHandlerItem(ItemStack container) {
        this.container = container;
    }

    public ItemStack getContainer() {
        return this.container;
    }

    public FluidStack getFluid() {
        CompoundTag tagCompound = this.container.m_41783_();
        if (tagCompound == null || !tagCompound.m_128441_("Fluid")) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tagCompound.m_128469_("Fluid"));
    }

    public void setFluid(FluidStack fluid) {
        if (fluid != null && !fluid.isEmpty()) {
            if (!this.container.m_41782_()) {
                this.container.m_41751_(new CompoundTag());
            }
            CompoundTag fluidTag = new CompoundTag();
            fluid.writeToNBT(fluidTag);
            this.container.m_41783_().m_128365_("Fluid", (Tag)fluidTag);
        }
    }

    protected void setContainerToEmpty() {
        this.container.m_41774_(1);
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getFluid().getAmount();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return 0;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack fluidStack = this.getFluid();
        if (resource.getAmount() < this.getFluid().getAmount()) {
            return FluidStack.EMPTY;
        }
        if (!fluidStack.isEmpty() && fluidStack.isFluidEqual(resource)) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack fluidStack = this.getFluid();
        if (maxDrain < fluidStack.getAmount()) {
            return FluidStack.EMPTY;
        }
        if (!fluidStack.isEmpty()) {
            if (action.execute()) {
                this.setContainerToEmpty();
            }
            return fluidStack;
        }
        return FluidStack.EMPTY;
    }
}

