/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.menu.EmptyMenu;
import thelm.packagedauto.recipe.CraftingPackageRecipeType;
import thelm.packagedauto.recipe.ICraftingPackageRecipeInfo;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.PackagePattern;

public class CraftingPackageRecipeInfo
implements ICraftingPackageRecipeInfo {
    CraftingRecipe recipe;
    List<ItemStack> input = new ArrayList<ItemStack>();
    CraftingContainer matrix = new CraftingContainer((AbstractContainerMenu)new EmptyMenu(), 3, 3);
    ItemStack output = ItemStack.f_41583_;
    List<IPackagePattern> patterns = new ArrayList<IPackagePattern>();

    @Override
    public void load(CompoundTag nbt) {
        int i;
        this.input.clear();
        this.output = ItemStack.f_41583_;
        this.patterns.clear();
        Recipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44043_(new ResourceLocation(nbt.m_128461_("Recipe"))).orElse(null);
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("Matrix", 10), matrixList);
        for (i = 0; i < 9 && i < matrixList.size(); ++i) {
            this.matrix.m_6836_(i, (ItemStack)matrixList.get(i));
        }
        if (recipe instanceof CraftingRecipe) {
            CraftingRecipe craftingRecipe;
            this.recipe = craftingRecipe = (CraftingRecipe)recipe;
            this.output = this.recipe.m_5874_((Container)this.matrix).m_41777_();
        }
        this.input.addAll(MiscHelper.INSTANCE.condenseStacks((Container)this.matrix));
        i = 0;
        while (i * 9 < this.input.size()) {
            this.patterns.add(new PackagePattern(this, i));
            ++i;
        }
    }

    @Override
    public void save(CompoundTag nbt) {
        if (this.recipe != null) {
            nbt.m_128359_("Recipe", this.recipe.m_6423_().toString());
        }
        ArrayList<ItemStack> matrixList = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            matrixList.add(this.matrix.m_8020_(i));
        }
        ListTag matrixTag = MiscHelper.INSTANCE.saveAllItems(new ListTag(), matrixList);
        nbt.m_128365_("Matrix", (Tag)matrixTag);
    }

    @Override
    public IPackageRecipeType getRecipeType() {
        return CraftingPackageRecipeType.INSTANCE;
    }

    @Override
    public boolean isValid() {
        return this.recipe != null;
    }

    @Override
    public List<IPackagePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    @Override
    public List<ItemStack> getInputs() {
        return Collections.unmodifiableList(this.input);
    }

    @Override
    public ItemStack getOutput() {
        return this.output.m_41777_();
    }

    @Override
    public CraftingRecipe getRecipe() {
        return this.recipe;
    }

    @Override
    public CraftingContainer getMatrix() {
        return this.matrix;
    }

    @Override
    public List<ItemStack> getRemainingItems() {
        return this.recipe.m_7457_((Container)this.matrix);
    }

    @Override
    public void generateFromStacks(List<ItemStack> input, List<ItemStack> output, Level level) {
        this.recipe = null;
        this.input.clear();
        this.patterns.clear();
        int[] slotArray = CraftingPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            ItemStack toSet = input.get(slotArray[i]);
            toSet.m_41764_(1);
            this.matrix.m_6836_(i, toSet.m_41777_());
        }
        CraftingRecipe recipe = MiscHelper.INSTANCE.getRecipeManager().m_44015_(RecipeType.f_44107_, (Container)this.matrix, level).orElse(null);
        if (recipe != null) {
            this.recipe = recipe;
            this.input.addAll(MiscHelper.INSTANCE.condenseStacks((Container)this.matrix));
            this.output = recipe.m_5874_((Container)this.matrix).m_41777_();
            int i = 0;
            while (i * 9 < this.input.size()) {
                this.patterns.add(new PackagePattern(this, i));
                ++i;
            }
            return;
        }
        this.matrix.m_6211_();
    }

    @Override
    public Int2ObjectMap<ItemStack> getEncoderStacks() {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        int[] slotArray = CraftingPackageRecipeType.SLOTS.toIntArray();
        for (int i = 0; i < 9; ++i) {
            map.put(slotArray[i], (Object)this.matrix.m_8020_(i));
        }
        return map;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CraftingPackageRecipeInfo) {
            CraftingPackageRecipeInfo other = (CraftingPackageRecipeInfo)obj;
            return MiscHelper.INSTANCE.recipeEquals(this, this.recipe, other, other.recipe);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return MiscHelper.INSTANCE.recipeHashCode(this, this.recipe);
    }
}

