/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.recipe;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.api.IRecipeSlotsViewWrapper;
import thelm.packagedauto.recipe.CraftingPackageRecipeInfo;

public class CraftingPackageRecipeType
implements IPackageRecipeType {
    public static final CraftingPackageRecipeType INSTANCE = new CraftingPackageRecipeType();
    public static final ResourceLocation NAME = new ResourceLocation("packagedauto:crafting");
    public static final IntSet SLOTS;
    public static final List<ResourceLocation> CATEGORIES;
    public static final Vec3i COLOR;
    public static final Vec3i COLOR_DISABLED;

    protected CraftingPackageRecipeType() {
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }

    @Override
    public MutableComponent getDisplayName() {
        return new TranslatableComponent("recipe.packagedauto.crafting");
    }

    @Override
    public MutableComponent getShortDisplayName() {
        return new TranslatableComponent("recipe.packagedauto.crafting.short");
    }

    @Override
    public IPackageRecipeInfo getNewRecipeInfo() {
        return new CraftingPackageRecipeInfo();
    }

    @Override
    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    @Override
    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    @Override
    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeSlotsViewWrapper recipeLayoutWrapper) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        List<IRecipeSlotViewWrapper> slotViews = recipeLayoutWrapper.getRecipeSlotViews();
        int index = 0;
        int[] slotArray = SLOTS.toIntArray();
        for (IRecipeSlotViewWrapper slotView : slotViews) {
            if (slotView.isInput()) {
                ItemStack stack;
                Object displayed = slotView.getDisplayedIngredient().orElse(null);
                if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).m_41619_()) {
                    map.put(slotArray[index], (Object)stack);
                }
                ++index;
            }
            if (index < 9) continue;
            break;
        }
        return map;
    }

    @Override
    public Object getRepresentation() {
        return new ItemStack((ItemLike)Blocks.f_50091_);
    }

    @Override
    public Vec3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 81) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = List.of(new ResourceLocation("minecraft:crafting"));
        COLOR = new Vec3i(139, 139, 139);
        COLOR_DISABLED = new Vec3i(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        for (int i = 3; i < 6; ++i) {
            for (int j = 3; j < 6; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

