/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.volume;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.fluids.FluidStack;
import thelm.packagedauto.api.IFluidStackWrapper;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.volume.FluidVolumeType;

public record FluidStackWrapper(FluidStack stack) implements IFluidStackWrapper
{
    public static final FluidStackWrapper EMPTY = new FluidStackWrapper(FluidStack.EMPTY);

    @Override
    public IVolumeType getVolumeType() {
        return FluidVolumeType.INSTANCE;
    }

    @Override
    public FluidStack getFluid() {
        return this.stack;
    }

    @Override
    public int getAmount() {
        return this.stack.getAmount();
    }

    @Override
    public IVolumeStackWrapper copy() {
        return new FluidStackWrapper(this.stack.copy());
    }

    @Override
    public void setAmount(int amount) {
        this.stack.setAmount(amount);
    }

    @Override
    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @Override
    public CompoundTag save(CompoundTag tag) {
        return this.stack.writeToNBT(tag);
    }

    @Override
    public CompoundTag saveAEKey(CompoundTag tag) {
        tag.m_128359_("#c", "ae2:f");
        tag.m_128359_("id", this.stack.getFluid().getRegistryName().toString());
        if (this.stack.hasTag()) {
            tag.m_128365_("tag", (Tag)this.stack.getTag().m_6426_());
        }
        return tag;
    }

    @Override
    public Component getDisplayName() {
        return this.stack.getDisplayName();
    }

    @Override
    public Component getAmountDesc() {
        return new TranslatableComponent("amount.packagedauto.mb", new Object[]{this.stack.getAmount()});
    }

    @Override
    public List<Component> getTooltip() {
        return List.of(this.stack.getDisplayName());
    }

    @Override
    public int hashCode() {
        return this.stack.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof FluidStackWrapper) {
            FluidStackWrapper other = (FluidStackWrapper)obj;
            return this.stack.equals((Object)other.stack);
        }
        return false;
    }
}

