package thelm.packagedauto.block.entity;

import java.util.UUID;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.BaseItemHandler;

public abstract class BaseBlockEntity extends BlockEntity implements Nameable, MenuProvider {

	protected BaseItemHandler<?> itemHandler = new BaseItemHandler<>(this, 0);
	protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
	public Component customName = null;
	protected UUID ownerUUID = null;
	@Deprecated
	protected int placerID = -1;

	public BaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
		super(blockEntityType, pos, state);
	}

	public BaseItemHandler<?> getItemHandler() {
		return itemHandler;
	}

	public void setItemHandler(BaseItemHandler<?> itemHandler) {
		this.itemHandler = itemHandler;
	}

	public EnergyStorage getEnergyStorage() {
		return energyStorage;
	}

	public void setEnergyStorage(EnergyStorage energyStorage) {
		this.energyStorage = energyStorage;
	}

	public void setOwner(Player owner) {
		ownerUUID = owner.m_20148_();
	}

	@Override
	public Component m_7755_() {
		return customName != null ? customName : getDefaultName();
	}

	@Override
	public Component m_5446_() {
		return m_7755_();
	}

	@Override
	public Component m_7770_() {
		return customName;
	}

	public void setCustomName(Component name) {
		customName = name;
	}

	protected abstract Component getDefaultName();

	public void tick() {}

	public int getComparatorSignal() {
		return ItemHandlerHelper.calcRedstoneFromInventory(itemHandler.getWrapperForDirection(null));
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		super.m_142466_(nbt);
		ownerUUID = null;
		if(nbt.m_128403_("OwnerUUID")) {
			ownerUUID = nbt.m_128342_("OwnerUUID");
		}
		loadSync(nbt);
		itemHandler.load(nbt);
		energyStorage.read(nbt);
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		if(ownerUUID != null) {
			nbt.m_128362_("OwnerUUID", ownerUUID);
		}
		saveSync(nbt);
		itemHandler.save(nbt);
		energyStorage.save(nbt);
	}

	public void loadSync(CompoundTag nbt) {
		if(nbt.m_128441_("Name")) {
			customName = Component.Serializer.m_130701_(nbt.m_128461_("Name"));
		}
	}

	public CompoundTag saveSync(CompoundTag nbt) {
		if(customName != null) {
			nbt.m_128359_("Name", Component.Serializer.m_130703_(customName));
		}
		return nbt;
	}

	@Override
	public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
		if(pkt.m_131708_() != null) {
			loadSync(pkt.m_131708_());
		}
	}

	@Override
	public Packet<ClientGamePacketListener> m_58483_() {
		return ClientboundBlockEntityDataPacket.m_195640_(this);
	}

	@Override
	public void handleUpdateTag(CompoundTag tag) {
		loadSync(tag);
	}

	@Override
	public CompoundTag m_5995_() {
		CompoundTag nbt = super.m_5995_();
		nbt.m_128473_("ForgeData");
		nbt.m_128473_("ForgeCaps");
		saveSync(nbt);
		return nbt;
	}

	public void sync(boolean rerender) {
		if(f_58857_ != null && f_58857_.m_46749_(f_58858_)) {
			BlockState state = f_58857_.m_8055_(f_58858_);
			f_58857_.m_7260_(f_58858_, state, state, 2 + (rerender ? 4 : 0));
		}
	}

	@Override
	public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction direction) {
		if(capability == ForgeCapabilities.ITEM_HANDLER) {
			return LazyOptional.of(()->(T)itemHandler.getWrapperForDirection(direction));
		}
		else if(capability == ForgeCapabilities.ENERGY && energyStorage.getMaxEnergyStored() > 0) {
			return LazyOptional.of(()->(T)energyStorage);
		}
		return super.getCapability(capability, direction);
	}

	public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
		if(blockEntity instanceof BaseBlockEntity baseBlockEntity) {
			baseBlockEntity.tick();
		}
	}
}
