package thelm.packagedauto.block.entity;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.CraftingProxyBlock;
import thelm.packagedauto.integration.appeng.blockentity.AECraftingProxyBlockEntity;
import thelm.packagedauto.inventory.CraftingProxyItemHandler;
import thelm.packagedauto.item.ProxyMarkerItem;
import thelm.packagedauto.menu.CraftingProxyMenu;
import thelm.packagedauto.network.packet.BeamPacket;
import thelm.packagedauto.network.packet.DirectionalMarkerPacket;
import thelm.packagedauto.network.packet.SizedMarkerPacket;
import thelm.packagedauto.util.MiscHelper;

public class CraftingProxyBlockEntity extends BaseBlockEntity implements IPackageCraftingMachine, ISettingsCloneable {

	public static final BlockEntityType<CraftingProxyBlockEntity> TYPE_INSTANCE = (BlockEntityType<CraftingProxyBlockEntity>)BlockEntityType.Builder.
			m_155273_(MiscHelper.INSTANCE.<BlockEntityType.BlockEntitySupplier<CraftingProxyBlockEntity>>conditionalSupplier(
					()->ModList.get().isLoaded("ae2"),
					()->()->AECraftingProxyBlockEntity::new, ()->()->CraftingProxyBlockEntity::new).get(),
					CraftingProxyBlock.INSTANCE).m_58966_(null);

	public static int range = 8;

	public final Cache<UUID, Long> previewTimes = CacheBuilder.newBuilder().initialCapacity(2).expireAfterWrite(60, TimeUnit.SECONDS).build();

	public DirectionalGlobalPos target;

	public CraftingProxyBlockEntity(BlockPos pos, BlockState state) {
		super(TYPE_INSTANCE, pos, state);
		setItemHandler(new CraftingProxyItemHandler(this));
	}

	@Override
	protected Component getDefaultName() {
		return Component.m_237115_("block.packagedauto.crafting_proxy");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.crafting_proxy";
	}

	@Override
	public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
		if(!isBusy()) {
			IPackageCraftingMachine machine = (IPackageCraftingMachine)f_58857_.m_7702_(target.blockPos());
			if(machine.acceptPackage(recipeInfo, stacks, target.direction())) {
				Direction dir = target.direction();
				Vec3 source = Vec3.m_82512_(f_58858_);
				Vec3 delta = Vec3.m_82528_(target.blockPos().m_121996_(f_58858_)).m_82549_(Vec3.m_82528_(dir.m_122436_()).m_82490_(0.5));
				BeamPacket.sendBeams(source, Collections.singletonList(delta), 0xFF7F00, 6, true, f_58857_.m_46472_(), 32);
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean isBusy() {
		if(target == null) {
			return true;
		}
		BlockPos pos = target.blockPos();
		if(!f_58857_.m_46749_(pos)) {
			return true;
		}
		BlockEntity blockEntity = f_58857_.m_7702_(pos);
		if(blockEntity != null &&
				!(blockEntity instanceof CraftingProxyBlockEntity) &&
				blockEntity instanceof IPackageCraftingMachine machine) {
			return machine.isBusy();
		}
		return true;
	}

	public void sendPreview(ServerPlayer player) {
		long currentTime = f_58857_.m_46467_();
		Long cachedTime = previewTimes.getIfPresent(player.m_20148_());
		if(cachedTime == null || currentTime-cachedTime > 180) {
			if(target != null) {
				Direction dir = target.direction();
				Vec3 source = Vec3.m_82512_(f_58858_);
				Vec3 delta = Vec3.m_82528_(target.blockPos().m_121996_(f_58858_)).m_82549_(Vec3.m_82528_(dir.m_122436_()).m_82490_(0.5));
				DirectionalMarkerPacket.sendDirectionalMarkers(player, Collections.singletonList(target), 0xFFFF00, 200);
				BeamPacket.sendBeams(player, source, Collections.singletonList(delta), 0xFFFF00, 200, false);
			}
			Vec3 lowerCorner = Vec3.m_82528_(f_58858_).m_82492_(range, range, range);
			Vec3 size = new Vec3(range*2+1, range*2+1, range*2+1);
			SizedMarkerPacket.sendSizedMarker(player, lowerCorner, size, 0xFF7F00, 200);
		}
	}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
		if(!nbt.m_128441_("Target")) {
			return ISettingsCloneable.Result.fail(Component.m_237115_("item.packagedauto.settings_cloner.invalid"));
		}
		int availableCount = 0;
		Inventory playerInventory = player.m_150109_();
		if(!itemHandler.getStackInSlot(0).m_41619_()) {
			if(itemHandler.getStackInSlot(0).m_150930_(ProxyMarkerItem.INSTANCE)) {
				availableCount += itemHandler.getStackInSlot(0).m_41613_();
			}
			else {
				return ISettingsCloneable.Result.fail(Component.m_237115_("block.packagedauto.crafting_proxy.non_marker_present"));
			}
		}
		f:if(availableCount < 1) {
			for(int i = 0; i < playerInventory.m_6643_(); ++i) {
				ItemStack stack = playerInventory.m_8020_(i);
				if(!stack.m_41619_() && stack.m_150930_(ProxyMarkerItem.INSTANCE) && !stack.m_41782_()) {
					availableCount += stack.m_41613_();
				}
				if(availableCount >= 1) {
					break f;
				}
			}
			return ISettingsCloneable.Result.fail(Component.m_237115_("block.packagedauto.crafting_proxy.no_markers"));
		}
		int removedCount = itemHandler.getStackInSlot(0).m_41613_();
		itemHandler.setStackInSlot(0, ItemStack.f_41583_);
		if(removedCount < 1) {
			for(int i = 0; i < playerInventory.m_6643_(); ++i) {
				ItemStack stack = playerInventory.m_8020_(i);
				if(!stack.m_41619_() && stack.m_150930_(ProxyMarkerItem.INSTANCE) && !stack.m_41782_()) {
					removedCount += stack.m_41620_(1).m_41613_();
				}
				if(removedCount >= 1) {
					break;
				}
			}
		}
		if(removedCount > 1) {
			ItemStack stack = new ItemStack(ProxyMarkerItem.INSTANCE, removedCount-1);
			if(!playerInventory.m_36054_(stack)) {
				ItemEntity item = new ItemEntity(f_58857_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
				item.m_32052_(player.m_20148_());
				f_58857_.m_7967_(item);
			}
		}
		CompoundTag targetTag = nbt.m_128469_("Target");
		ResourceKey<Level> dimension = ResourceKey.m_135785_(Registry.f_122819_, new ResourceLocation(targetTag.m_128461_("Dimension")));
		int[] posArray = targetTag.m_128465_("Position");
		BlockPos blockPos = new BlockPos(posArray[0], posArray[1], posArray[2]);
		Direction direction = Direction.m_122376_(targetTag.m_128445_("Direction"));
		DirectionalGlobalPos globalPos = new DirectionalGlobalPos(dimension, blockPos, direction);
		ItemStack stack = new ItemStack(ProxyMarkerItem.INSTANCE);
		ProxyMarkerItem.INSTANCE.setDirectionalGlobalPos(stack, globalPos);
		itemHandler.setStackInSlot(0, stack);
		return ISettingsCloneable.Result.success();
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
		if(target == null) {
			return ISettingsCloneable.Result.fail(Component.m_237115_("block.packagedauto.crafting_proxy.empty"));
		}
		CompoundTag targetTag = new CompoundTag();
		targetTag.m_128359_("Dimension", target.dimension().m_135782_().toString());
		targetTag.m_128385_("Position", new int[] {target.x(), target.y(), target.z()});
		targetTag.m_128344_("Direction", (byte)target.direction().m_122411_());
		nbt.m_128365_("Target", targetTag);
		return ISettingsCloneable.Result.success();
	}

	@Override
	public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
		sync(false);
		return new CraftingProxyMenu(windowId, inventory, this);
	}
}
