package thelm.packagedauto.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler.FluidAction;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.block.FluidPackageFillerBlock;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.FluidPackageFillerItemHandler;
import thelm.packagedauto.menu.FluidPackageFillerMenu;
import thelm.packagedauto.util.MiscHelper;

public class FluidPackageFillerBlockEntity extends BaseBlockEntity implements ISettingsCloneable {

	public static final BlockEntityType<FluidPackageFillerBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.
			m_155273_(FluidPackageFillerBlockEntity::new, FluidPackageFillerBlock.INSTANCE).m_58966_(null);

	public static int energyCapacity = 5000;
	public static int energyReq = 500;
	public static int energyUsage = 100;
	public static int refreshInterval = 4;

	public boolean firstTick = true;
	public boolean isWorking = false;
	public FluidStack currentFluid = FluidStack.EMPTY;
	public int requiredAmount = 100;
	public int amount = 0;
	public int remainingProgress = 0;
	public boolean powered = false;
	public boolean activated = false;

	public FluidPackageFillerBlockEntity(BlockPos pos, BlockState state) {
		super(TYPE_INSTANCE, pos, state);
		setItemHandler(new FluidPackageFillerItemHandler(this));
		setEnergyStorage(new EnergyStorage(this, energyCapacity));
	}

	@Override
	protected Component getDefaultName() {
		return Component.m_237115_("block.packagedauto.fluid_package_filler");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.fluid_package_filler";
	}

	@Override
	public void tick() {
		if(firstTick) {
			firstTick = false;
			updatePowered();
		}
		if(!f_58857_.f_46443_) {
			if(isWorking) {
				tickProcess();
				if(remainingProgress <= 0 && isTemplateValid()) {
					finishProcess();
					if(!itemHandler.getStackInSlot(1).m_41619_()) {
						ejectItem();
					}
					if(!canStart()) {
						endProcess();
					}
					else {
						startProcess();
					}
				}
			}
			else if(activated) {
				if(canStart()) {
					startProcess();
					tickProcess();
					activated = false;
					isWorking = true;
				}
			}
			chargeEnergy();
			if(f_58857_.m_46467_() % refreshInterval == 0) {
				if(!itemHandler.getStackInSlot(1).m_41619_()) {
					ejectItem();
				}
			}
		}
	}

	public boolean isTemplateValid() {
		if(currentFluid.isEmpty()) {
			getFluid();
		}
		if(currentFluid.isEmpty()) {
			return false;
		}
		return true;
	}

	public boolean canStart() {
		getFluid();
		if(currentFluid.isEmpty()) {
			return false;
		}
		if(!isTemplateValid()) {
			return false;
		}
		ItemStack slotStack = itemHandler.getStackInSlot(1);
		ItemStack outputStack = MiscHelper.INSTANCE.tryMakeVolumePackage(currentFluid);
		return slotStack.m_41619_() || ItemStack.m_150942_(slotStack, outputStack) && slotStack.m_41613_()+1 <= outputStack.m_41741_();
	}

	protected boolean canFinish() {
		return remainingProgress <= 0 && isTemplateValid();
	}

	protected void getFluid() {
		currentFluid = FluidStack.EMPTY;
		ItemStack template = itemHandler.getStackInSlot(0);
		if(template.m_41619_()) {
			return;
		}
		FluidUtil.getFluidContained(template).filter(s->!s.isEmpty()).ifPresent(s->{
			(currentFluid = s.copy()).setAmount(requiredAmount);
		});
	}

	protected void tickProcess() {
		if(amount < requiredAmount) {
			for(Direction direction : Direction.values()) {
				BlockEntity blockEntity = f_58857_.m_7702_(f_58858_.m_121945_(direction));
				if(blockEntity != null && blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).isPresent()) {
					IFluidHandler fluidHandler = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).resolve().get();
					FluidStack toDrain = currentFluid.copy();
					toDrain.setAmount(requiredAmount-amount);
					amount += fluidHandler.drain(toDrain, FluidAction.EXECUTE).getAmount();
				}
			}
		}
		if(amount >= requiredAmount) {
			int energy = energyStorage.extractEnergy(Math.min(energyUsage, remainingProgress), false);
			remainingProgress -= energy;
		}
	}

	protected void finishProcess() {
		if(currentFluid.isEmpty()) {
			getFluid();
		}
		if(currentFluid.isEmpty()) {
			endProcess();
			return;
		}
		if(itemHandler.getStackInSlot(1).m_41619_()) {
			itemHandler.setStackInSlot(1, MiscHelper.INSTANCE.tryMakeVolumePackage(currentFluid));
		}
		else if(itemHandler.getStackInSlot(1).m_41720_() instanceof IVolumePackageItem) {
			itemHandler.getStackInSlot(1).m_41769_(1);
		}
		endProcess();
	}

	public void startProcess() {
		remainingProgress = energyReq;
		amount = 0;
		sync(false);
		m_6596_();
	}

	public void endProcess() {
		remainingProgress = 0;
		amount = 0;
		isWorking = false;
		m_6596_();
	}

	protected void ejectItem() {
		for(Direction direction : Direction.values()) {
			BlockEntity blockEntity = f_58857_.m_7702_(f_58858_.m_121945_(direction));
			if(blockEntity != null && !(blockEntity instanceof UnpackagerBlockEntity)
					&& blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).isPresent()
					&& !blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER, direction.m_122424_()).isPresent()) {
				IItemHandler itemHandler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()).resolve().get();
				ItemStack stack = this.itemHandler.getStackInSlot(1);
				if(!stack.m_41619_()) {
					ItemStack stackRem = ItemHandlerHelper.insertItem(itemHandler, stack, false);
					this.itemHandler.setStackInSlot(1, stackRem);
				}
			}
		}
	}

	protected void chargeEnergy() {
		ItemStack energyStack = itemHandler.getStackInSlot(2);
		if(energyStack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
			int energyRequest = Math.min(energyStorage.getMaxReceive(), energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored());
			energyStorage.receiveEnergy(energyStack.getCapability(ForgeCapabilities.ENERGY).resolve().get().extractEnergy(energyRequest, false), false);
			if(energyStack.m_41613_() <= 0) {
				itemHandler.setStackInSlot(2, ItemStack.f_41583_);
			}
		}
	}

	public void updatePowered() {
		if(f_58857_.m_46755_(f_58858_) > 0 != powered) {
			powered = !powered;
			if(powered && !isWorking) {
				activated = true;
			}
			m_6596_();
		}
	}

	@Override
	public int getComparatorSignal() {
		if(isWorking) {
			return 1;
		}
		if(!itemHandler.getStackInSlot(1).m_41619_()) {
			return 15;
		}
		return 0;
	}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
		requiredAmount = nbt.m_128451_("AmountReq");
		return ISettingsCloneable.Result.success();
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
		nbt.m_128405_("AmountReq", requiredAmount);
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		super.m_142466_(nbt);
		isWorking = nbt.m_128471_("Working");
		amount = nbt.m_128451_("Amount");
		remainingProgress = nbt.m_128451_("Progress");
		powered = nbt.m_128471_("Powered");
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		nbt.m_128379_("Working", isWorking);
		nbt.m_128405_("Amount", amount);
		nbt.m_128405_("Progress", remainingProgress);
		nbt.m_128379_("Powered", powered);
	}

	@Override
	public void loadSync(CompoundTag nbt) {
		super.loadSync(nbt);
		currentFluid = FluidStack.loadFluidStackFromNBT(nbt.m_128469_("Fluid"));
		requiredAmount = nbt.m_128451_("AmountReq");
	}

	@Override
	public CompoundTag saveSync(CompoundTag nbt) {
		super.saveSync(nbt);
		nbt.m_128365_("Fluid", currentFluid.writeToNBT(new CompoundTag()));
		nbt.m_128405_("AmountReq", requiredAmount);
		return nbt;
	}

	@Override
	public void m_6596_() {
		if(isWorking && !isTemplateValid()) {
			endProcess();
		}
		super.m_6596_();
	}

	public int getScaledEnergy(int scale) {
		if(energyStorage.getMaxEnergyStored() <= 0) {
			return 0;
		}
		return Math.min(scale * energyStorage.getEnergyStored() / energyStorage.getMaxEnergyStored(), scale);
	}

	public int getScaledProgress(int scale) {
		if(remainingProgress <= 0 || energyReq <= 0) {
			return 0;
		}
		return scale * (energyReq-remainingProgress) / energyReq;
	}

	@Override
	public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
		sync(false);
		return new FluidPackageFillerMenu(windowId, inventory, this);
	}
}
