package thelm.packagedauto.block.entity;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.ModList;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.PackagingProviderBlock;
import thelm.packagedauto.integration.appeng.blockentity.AEPackagingProviderBlockEntity;
import thelm.packagedauto.inventory.PackagingProviderItemHandler;
import thelm.packagedauto.item.RecipeHolderItem;
import thelm.packagedauto.menu.PackagingProviderMenu;
import thelm.packagedauto.util.MiscHelper;

public class PackagingProviderBlockEntity extends BaseBlockEntity implements ISettingsCloneable {

	public static final BlockEntityType<PackagingProviderBlockEntity> TYPE_INSTANCE = BlockEntityType.Builder.
			m_155273_(MiscHelper.INSTANCE.<BlockEntityType.BlockEntitySupplier<PackagingProviderBlockEntity>>conditionalSupplier(
					()->ModList.get().isLoaded("ae2"),
					()->()->AEPackagingProviderBlockEntity::new, ()->()->PackagingProviderBlockEntity::new).get(),
					PackagingProviderBlock.INSTANCE).
			m_58966_(null);

	public List<IPackageRecipeInfo> recipeList = new ArrayList<>();
	public IPackagePattern currentPattern;
	public List<ItemStack> toSend = new ArrayList<>();
	public Direction sendDirection;
	public boolean sendOrdered;
	public boolean powered = false;
	public boolean blocking = false;
	public boolean provideDirect = true;
	public boolean providePackaging = false;
	public boolean provideUnpackaging = false;

	public PackagingProviderBlockEntity(BlockPos pos, BlockState state) {
		super(TYPE_INSTANCE, pos, state);
		setItemHandler(new PackagingProviderItemHandler(this));
	}

	@Override
	protected Component getDefaultName() {
		return Component.m_237115_("block.packagedauto.packaging_provider");
	}

	@Override
	public String getConfigTypeName() {
		return "block.packagedauto.packaging_provider";
	}

	public void updatePowered() {
		if(f_58857_.m_46755_(f_58858_) > 0 != powered) {
			powered = !powered;
			m_6596_();
		}
	}

	public void changeBlockingMode() {
		blocking = !blocking;
		m_6596_();
	}

	public void changeProvideType(Type type) {
		switch(type) {
		case DIRECT -> {
			provideDirect = !provideDirect;
			if(provideDirect && providePackaging && provideUnpackaging) {
				providePackaging = provideUnpackaging = false;
			}
			if(!provideDirect && !providePackaging && !provideUnpackaging) {
				providePackaging = provideUnpackaging = true;
			}
		}
		case PACKAGING -> {
			providePackaging = !providePackaging;
			if(provideDirect && providePackaging && provideUnpackaging) {
				provideDirect = false;
			}
			if(!provideDirect && !providePackaging && !provideUnpackaging) {
				provideDirect = true;
			}
		}
		case UNPACKAGING -> {
			provideUnpackaging = !provideUnpackaging;
			if(provideDirect && providePackaging && provideUnpackaging) {
				provideDirect = false;
			}
			if(!provideDirect && !providePackaging && !provideUnpackaging) {
				provideDirect = true;
			}
		}
		}
		postPatternChange();
		m_6596_();
	}

	public void postPatternChange() {}

	@Override
	public ISettingsCloneable.Result loadConfig(CompoundTag nbt, Player player) {
		blocking = nbt.m_128471_("Blocking");
		provideDirect = nbt.m_128471_("Direct");
		providePackaging = nbt.m_128471_("Packaging");
		provideUnpackaging = nbt.m_128471_("Unpackaging");
		Component message = null;
		if(nbt.m_128441_("Recipes")) {
			f:if(itemHandler.getStackInSlot(0).m_41619_()) {
				Inventory playerInventory = player.m_150109_();
				for(int i = 0; i < playerInventory.m_6643_(); ++i) {
					ItemStack stack = playerInventory.m_8020_(i);
					if(!stack.m_41619_() && stack.m_150930_(RecipeHolderItem.INSTANCE) && !stack.m_41782_()) {
						ItemStack stackCopy = stack.m_41620_(1);
						IPackageRecipeList recipeListObj = RecipeHolderItem.INSTANCE.getRecipeList(stackCopy);
						List<IPackageRecipeInfo> recipeList = MiscHelper.INSTANCE.loadRecipeList(nbt.m_128437_("Recipes", 10));
						recipeListObj.setRecipeList(recipeList);
						RecipeHolderItem.INSTANCE.setRecipeList(stackCopy, recipeListObj);
						itemHandler.setStackInSlot(0, stackCopy);
						break f;
					}
				}
				message = Component.m_237115_("block.packagedauto.packaging_provider.no_holders");
			}
			else {
				message = Component.m_237115_("block.packagedauto.packaging_provider.holder_present");
			}
		}
		if(message != null) {
			return ISettingsCloneable.Result.partial(message);
		}
		else {
			return ISettingsCloneable.Result.success();
		}
	}

	@Override
	public ISettingsCloneable.Result saveConfig(CompoundTag nbt, Player player) {
		nbt.m_128379_("Blocking", blocking);
		nbt.m_128379_("Direct", provideDirect);
		nbt.m_128379_("Packaging", providePackaging);
		nbt.m_128379_("Unpackaging", provideUnpackaging);
		if(!recipeList.isEmpty()) {
			nbt.m_128365_("Recipes", MiscHelper.INSTANCE.saveRecipeList(new ListTag(), recipeList));
		}
		return ISettingsCloneable.Result.success();
	}

	@Override
	public void m_142466_(CompoundTag nbt) {
		super.m_142466_(nbt);
		blocking = nbt.m_128471_("Blocking");
		provideDirect = nbt.m_128471_("Direct");
		providePackaging = nbt.m_128471_("Packaging");
		provideUnpackaging = nbt.m_128471_("Unpackaging");
		powered = nbt.m_128471_("Powered");
		if(nbt.m_128441_("Pattern")) {
			CompoundTag tag = nbt.m_128469_("Pattern");
			IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag);
			if(recipe != null) {
				List<IPackagePattern> patterns = recipe.getPatterns();
				byte index = tag.m_128445_("Index");
				if(index >= 0 && index < patterns.size()) {
					currentPattern = patterns.get(index);
				}
			}
		}
		MiscHelper.INSTANCE.loadAllItems(nbt.m_128437_("ToSend", 10), toSend);
		if(nbt.m_128441_("SendDirection")) {
			sendDirection = Direction.m_122376_(nbt.m_128445_("SendDirection"));
		}
		sendOrdered = nbt.m_128471_("SendOrdered");
	}

	@Override
	public void m_183515_(CompoundTag nbt) {
		super.m_183515_(nbt);
		nbt.m_128379_("Blocking", blocking);
		nbt.m_128379_("Direct", provideDirect);
		nbt.m_128379_("Packaging", providePackaging);
		nbt.m_128379_("Unpackaging", provideUnpackaging);
		nbt.m_128379_("Powered", powered);
		if(currentPattern != null) {
			CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), currentPattern.getRecipeInfo());
			tag.m_128344_("Index", (byte)currentPattern.getIndex());
			nbt.m_128365_("Pattern", tag);
		}
		nbt.m_128365_("ToSend", MiscHelper.INSTANCE.saveAllItems(new ListTag(), toSend));
		if(sendDirection != null) {
			nbt.m_128344_("SendDirection", (byte)sendDirection.m_122411_());
		}
		nbt.m_128379_("SendOrdered", sendOrdered);
	}

	@Override
	public AbstractContainerMenu m_7208_(int windowId, Inventory inventory, Player player) {
		sync(false);
		return new PackagingProviderMenu(windowId, inventory, this);
	}

	public static enum Type {
		DIRECT, PACKAGING, UNPACKAGING;
	}
}
