package thelm.packagedauto.client.screen;

import org.lwjgl.glfw.GLFW;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.menu.BaseMenu;

// Code from Refined Storage
public abstract class AmountSpecifyingScreen<C extends BaseMenu<?>> extends BaseScreen<C> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/amount_specifying.png");

	private BaseScreen<?> parent;

	protected EditBox amountField;

	public AmountSpecifyingScreen(BaseScreen<?> parent, C menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
		f_97726_ = 172;
		f_97727_ = 99;
		this.parent = parent;
	}

	protected abstract int getDefaultAmount();

	protected abstract int getMaxAmount();

	protected abstract int[] getIncrements();

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	protected void m_7856_() {
		m_169413_();
		super.m_7856_();

		m_142416_(new ButtonSet(f_97735_+114, f_97736_+22, Component.m_237115_("misc.packagedauto.set")));
		m_142416_(new ButtonCancel(f_97735_+114, f_97736_+22+24, Component.m_237115_("gui.cancel")));

		amountField = new EditBox(f_96547_, f_97735_+9, f_97736_+51, 63, f_96547_.f_92710_, Component.m_237119_());
		amountField.m_94182_(false);
		amountField.m_94144_(String.valueOf(getDefaultAmount()));
		amountField.m_94202_(0xFFFFFF);
		amountField.m_94153_(s->{
			if(s.isEmpty()) {
				return true;
			}
			try {
				int amount = Integer.parseInt(s);
				return amount >= 0 && amount <= getMaxAmount();
			}
			catch(NumberFormatException e) {
				return false;
			}
		});
		m_142416_(amountField);

		int[] increments = getIncrements();

		int xx = 7;
		int width = 34;
		for(int i = 0; i < 3; ++i) {
			int increment = increments[i];
			String text = "+" + increment;
			m_142416_(new ButtonIncrement(increment, f_97735_+xx, f_97736_+20, Component.m_237113_(text)));
			xx += width;
		}

		xx = 7;
		for(int i = 0; i < 3; ++i) {
			int increment = increments[i];
			String text = "-" + increment;
			m_142416_(new ButtonIncrement(-increment, f_97735_+xx, f_97736_+f_97727_-20-7, Component.m_237113_(text)));
			xx += width;
		}
	}

	@Override
	protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
		amountField.m_6303_(poseStack, mouseX, mouseY, partialTicks);
	}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		f_96547_.m_92883_(poseStack, m_96636_().getString(), 7, 7, 0x404040);
		super.m_7027_(poseStack, mouseX, mouseY);
	}

	@Override
	public boolean m_7933_(int key, int scanCode, int modifiers) {
		if(key == GLFW.GLFW_KEY_ESCAPE) {
			close();
			return true;
		}
		if((key == GLFW.GLFW_KEY_ENTER || key == GLFW.GLFW_KEY_KP_ENTER) && amountField.m_93696_()) {
			onOkButtonPressed(m_96638_());
			return true;
		}
		if(amountField.m_7933_(key, scanCode, modifiers)) {
			return true;
		}
		InputConstants.Key mouseKey = InputConstants.m_84827_(key, scanCode);
		if(f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && amountField.m_93696_()) {
			return true;
		}
		return super.m_7933_(key, scanCode, modifiers);
	}

	private void onIncrementButtonClicked(int increment) {
		int oldAmount = 0;
		try {
			oldAmount = Integer.parseInt(amountField.m_94155_());
		}
		catch(NumberFormatException e) {
			// NO OP
		}
		int newAmount = Mth.m_14045_(oldAmount+increment, 0, getMaxAmount());
		amountField.m_94144_(String.valueOf(newAmount));
	}

	protected abstract void onOkButtonPressed(boolean shiftDown);

	public void close() {
		f_96541_.m_91152_(parent);
	}

	public BaseScreen<?> getParent() {
		return parent;
	}

	class ButtonSet extends AbstractWidget {

		public ButtonSet(int x, int y, Component text) {
			super(x, y, 50, 20, text);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			onOkButtonPressed(m_96638_());
		}

		@Override
		public void m_142291_(NarrationElementOutput pNarrationElementOutput) {}
	}

	class ButtonCancel extends AbstractWidget {

		public ButtonCancel(int x, int y, Component text) {
			super(x, y, 50, 20, text);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			close();
		}

		@Override
		public void m_142291_(NarrationElementOutput pNarrationElementOutput) {}
	}

	class ButtonIncrement extends AbstractWidget {

		int increment;

		public ButtonIncrement(int increment, int x, int y, Component text) {
			super(x, y, 34, 20, text);
			this.increment = increment;
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			onIncrementButtonClicked(increment);
		}

		@Override
		public void m_142291_(NarrationElementOutput pNarrationElementOutput) {}
	}
}
