package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.menu.BaseMenu;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.slot.FalseCopyVolumeSlot;
import thelm.packagedauto.slot.PreviewSlot;

public abstract class BaseScreen<C extends BaseMenu<?>> extends AbstractContainerScreen<C> {

	public final C menu;

	public BaseScreen(C menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
		this.menu = menu;
	}

	@Override
	public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
		m_7333_(poseStack);
		super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
		m_7025_(poseStack, mouseX, mouseY);
	}

	protected abstract ResourceLocation getBackgroundTexture();

	@Override
	protected void m_7286_(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
		RenderSystem.m_157429_(1F, 1F, 1F, 1F);
		RenderSystem.m_157456_(0, getBackgroundTexture());
		if(f_97726_ > 256 || f_97727_ > 256) {
			m_93133_(poseStack, f_97735_, f_97736_, 0, 0, f_97726_, f_97727_, 512, 512);
		}
		else {
			m_93228_(poseStack, f_97735_, f_97736_, 0, 0, f_97726_, f_97727_);
		}
		renderBgAdditional(poseStack, partialTicks, mouseX, mouseY);
		for(int i = 0; i < menu.f_38839_.size(); ++i) {
			Slot slot = menu.f_38839_.get(i);
			if(slot.m_6659_()) {
				if(slot instanceof FalseCopyVolumeSlot vSlot) {
					IVolumeStackWrapper stack = vSlot.volumeInventory.getStackInSlot(slot.getSlotIndex());
					if(!stack.isEmpty()) {
						stack.getVolumeType().render(poseStack, f_97735_+slot.f_40220_, f_97736_+slot.f_40221_, stack);
						renderQuantity(poseStack, f_97735_+slot.f_40220_, f_97736_+slot.f_40221_, String.valueOf(stack.getAmount()), 0xFFFFFF);
					}
				}
				else if((slot instanceof FalseCopySlot || slot instanceof PreviewSlot)
						&& slot.m_7993_().m_41720_() instanceof IVolumePackageItem vPackage) {
					IVolumeStackWrapper stack = vPackage.getVolumeStack(slot.m_7993_());
					if(!stack.isEmpty()) {
						stack.getVolumeType().render(poseStack, f_97735_+slot.f_40220_, f_97736_+slot.f_40221_, stack);
					}
				}
			}
		}
	}

	protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		for(int i = 0; i < menu.f_38839_.size(); ++i) {
			Slot slot = menu.f_38839_.get(i);
			if(slot.m_6659_() && slot instanceof FalseCopyVolumeSlot vSlot) {
				IVolumeStackWrapper stack = vSlot.volumeInventory.getStackInSlot(slot.getSlotIndex());
				if(!stack.isEmpty() && inBounds(slot.f_40220_, slot.f_40221_, 17, 17, mouseX-f_97735_, mouseY-f_97736_)) {
					m_96597_(poseStack, stack.getTooltip(), mouseX-f_97735_, mouseY-f_97736_);
				}
			}
		}
	}

	@Override
	protected void m_6597_(Slot slot, int slotId, int mouseButton, ClickType type) {
		if(mouseButton == 0 &&
				type != ClickType.QUICK_MOVE &&
				menu.m_142621_().m_41619_() &&
				slot instanceof FalseCopySlot &&
				slot.m_6659_() &&
				!slot.m_7993_().m_41619_()) {
			if(!m_96637_() && slot.m_7993_().m_41720_() instanceof IVolumePackageItem vPackage) {
				f_96541_.m_91152_(new VolumeAmountSpecifyingScreen(
						this, f_96541_.f_91074_.m_150109_(), slot.f_40219_, vPackage.getVolumeStack(slot.m_7993_()), getVolumeAmountSpecificationLimit(slot)));
			}
			else {
				f_96541_.m_91152_(new ItemAmountSpecifyingScreen(
						this, f_96541_.f_91074_.m_150109_(), slot.f_40219_, slot.m_7993_(), getItemAmountSpecificationLimit(slot)));
			}
		}
		else {
			super.m_6597_(slot, slotId, mouseButton, type);
		}
	}

	public int getItemAmountSpecificationLimit(Slot slot) {
		return Math.min(slot.m_6641_(), slot.m_7993_().m_41741_());
	}

	public int getVolumeAmountSpecificationLimit(Slot slot) {
		return 1000000;
	}

	public boolean inBounds(int x, int y, int w, int h, double ox, double oy) {
		return ox >= x && ox <= x + w && oy >= y && oy <= y + h;
	}

	public void renderQuantity(PoseStack poseStack, int x, int y, String qty, int color) {
		boolean large = f_96541_.m_91390_();
		poseStack.m_85836_();
		poseStack.m_85837_(x, y, 300);
		if(!large) {
			poseStack.m_85841_(0.5F, 0.5F, 1);
		}
		f_96547_.m_92750_(poseStack, qty, (large ? 16 : 30) - f_96547_.m_92895_(qty), large ? 8 : 22, color);
		poseStack.m_85849_();
	}
}
