package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.menu.CrafterMenu;

public class CrafterScreen extends BaseScreen<CrafterMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/crafter.png");

	public CrafterScreen(CrafterMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
		m_93228_(poseStack, f_97735_+102, f_97736_+35, 176, 0, menu.blockEntity.getScaledProgress(22), 16);
		int scaledEnergy = menu.blockEntity.getScaledEnergy(40);
		m_93228_(poseStack, f_97735_+10, f_97736_+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
	}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		f_96547_.m_92883_(poseStack, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040);
		f_96547_.m_92883_(poseStack, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		if(mouseX-f_97735_ >= 10 && mouseY-f_97736_ >= 10 && mouseX-f_97735_ <= 21 && mouseY-f_97736_ <= 49) {
			m_96602_(poseStack, Component.m_237113_(menu.blockEntity.getEnergyStorage().getEnergyStored()+" / "+menu.blockEntity.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-f_97735_, mouseY-f_97736_);
		}
		super.m_7027_(poseStack, mouseX, mouseY);
	}
}
