package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.fluids.FluidStack;
import thelm.packagedauto.client.FluidRenderer;
import thelm.packagedauto.menu.FluidPackageFillerMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.SetFluidAmountPacket;

public class FluidPackageFillerScreen extends BaseScreen<FluidPackageFillerMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/fluid_package_filler.png");
	public static final FluidRenderer FLUID_RENDERER = new FluidRenderer(16, 52, 1);

	protected EditBox amountField;

	public FluidPackageFillerScreen(FluidPackageFillerMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	protected void m_7856_() {
		m_169413_();
		super.m_7856_();
		amountField = new EditBox(f_96547_, f_97735_+30, f_97736_+57, 41, f_96547_.f_92710_, Component.m_237119_());
		amountField.m_94182_(false);
		amountField.m_94144_(String.valueOf(menu.blockEntity.requiredAmount));
		amountField.m_94202_(0xFFFFFF);
		amountField.m_94153_(s->{
			if(menu.blockEntity.isWorking) {
				return false;
			}
			if(s.isEmpty()) {
				return true;
			}
			try {
				int amount = Integer.parseInt(s);
				return amount >= 1 && amount <= 1000000;
			}
			catch(NumberFormatException e) {
				return false;
			}
		});
		amountField.m_94151_(s->{
			try {
				int amount = Mth.m_14045_(Integer.parseInt(amountField.m_94155_()), 1, 1000000);
				if(amount != menu.blockEntity.requiredAmount) {
					PacketHandler.INSTANCE.sendToServer(new SetFluidAmountPacket(amount));
				}
			}
			catch(NumberFormatException e) {
				// NO OP
			}
		});
		m_142416_(amountField);
	}

	@Override
	protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
		m_93228_(poseStack, f_97735_+102, f_97736_+35, 176, 0, menu.blockEntity.getScaledProgress(22), 16);
		int scaledEnergy = menu.blockEntity.getScaledEnergy(40);
		m_93228_(poseStack, f_97735_+10, f_97736_+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
		if(menu.blockEntity.isWorking) {
			m_93228_(poseStack, f_97735_+102, f_97736_+30, 176, 61, 6, 5);
		}
		else {
			m_93228_(poseStack, f_97735_+102, f_97736_+30, 176, 56, 6, 5);
		}
		amountField.m_6303_(poseStack, mouseX, mouseY, partialTicks);

		FluidStack stack = menu.blockEntity.currentFluid.copy();
		if(!stack.isEmpty()) {
			stack.setAmount(menu.blockEntity.amount);
			FLUID_RENDERER.render(poseStack, f_97735_+80, f_97736_+17, stack, menu.blockEntity.requiredAmount);
		}
	}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		f_96547_.m_92883_(poseStack, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040);
		f_96547_.m_92883_(poseStack, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		if(mouseX-f_97735_ >= 10 && mouseY-f_97736_ >= 10 && mouseX-f_97735_ <= 21 && mouseY-f_97736_ <= 49) {
			m_96602_(poseStack, Component.m_237113_(menu.blockEntity.getEnergyStorage().getEnergyStored()+" / "+menu.blockEntity.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-f_97735_, mouseY-f_97736_);
		}
		if(!menu.blockEntity.isWorking && mouseX-f_97735_ >= 102 && mouseY-f_97736_ >= 30 && mouseX-f_97735_ <= 107 && mouseY-f_97736_ <= 34) {
			m_96602_(poseStack, Component.m_237115_("block.packagedauto.fluid_package_filler.redstone"), mouseX-f_97735_, mouseY-f_97736_);
		}
		if(menu.blockEntity.isWorking && !menu.blockEntity.currentFluid.isEmpty() && mouseX-f_97735_ >= 80 && mouseY-f_97736_ >= 17 && mouseX-f_97735_ <= 95 && mouseY-f_97736_ <= 68) {
			m_96602_(poseStack, Component.m_237113_("").m_7220_(menu.blockEntity.currentFluid.getDisplayName()).m_130946_(" "+menu.blockEntity.amount+" / "+menu.blockEntity.requiredAmount+" mB"), mouseX-f_97735_, mouseY-f_97736_);
		}
		super.m_7027_(poseStack, mouseX, mouseY);
	}

	@Override
	public boolean m_7933_(int key, int scanCode, int modifiers) {
		if(amountField.m_7933_(key, scanCode, modifiers)) {
			return true;
		}
		InputConstants.Key mouseKey = InputConstants.m_84827_(key, scanCode);
		if(f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && amountField.m_93696_()) {
			return true;
		}
		return super.m_7933_(key, scanCode, modifiers);
	}
}
