package thelm.packagedauto.client.screen;

import java.util.Arrays;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import thelm.packagedauto.block.entity.UnpackagerBlockEntity.PackageTracker;
import thelm.packagedauto.menu.UnpackagerMenu;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.ChangeBlockingPacket;
import thelm.packagedauto.network.packet.EjectTrackerPacket;
import thelm.packagedauto.network.packet.TrackerCountPacket;

public class UnpackagerScreen extends BaseScreen<UnpackagerMenu> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/unpackager.png");

	public UnpackagerScreen(UnpackagerMenu menu, Inventory inventory, Component title) {
		super(menu, inventory, title);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void m_7856_() {
		m_169413_();
		super.m_7856_();
		m_142416_(new ButtonChangeBlocking(f_97735_+98, f_97736_+16));
		for(int i = 0; i < 10; ++i) {
			m_142416_(new ButtonTracker(i, f_97735_+115, f_97736_+16+6*i));
		}
		m_142416_(new ButtonTrackerCount(true, f_97735_+98, f_97736_+34));
		m_142416_(new ButtonTrackerCount(false, f_97735_+106, f_97736_+34));
	}

	@Override
	protected void renderBgAdditional(PoseStack poseStack, float partialTicks, int mouseX, int mouseY) {
		int scaledEnergy = menu.blockEntity.getScaledEnergy(40);
		m_93228_(poseStack, f_97735_+10, f_97736_+10+40-scaledEnergy, 176, 40-scaledEnergy, 12, scaledEnergy);
		for(int i = 0; i < menu.blockEntity.trackers.length; ++i) {
			PackageTracker tracker = menu.blockEntity.trackers[i];
			for(int j = 0; j < 9; ++j) {
				if(j < tracker.amount) {
					if(tracker.received.getBoolean(j)) {
						m_93228_(poseStack, f_97735_+115+6*j, f_97736_+16+6*i, 176, 45, 6, 5);
					}
					else {
						m_93228_(poseStack, f_97735_+115+6*j, f_97736_+16+6*i, 176, 40, 6, 5);
					}
				}
				else if(i < menu.blockEntity.trackerCount) {
					m_93228_(poseStack, f_97735_+115+6*j, f_97736_+16+6*i, 182, 45, 6, 5);
				}
				else {
					m_93228_(poseStack, f_97735_+115+6*j, f_97736_+16+6*i, 182, 40, 6, 5);
				}
			}
		}
	}

	@Override
	protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
		String s = menu.blockEntity.m_5446_().getString();
		f_96547_.m_92883_(poseStack, s, f_97726_/2 - f_96547_.m_92895_(s)/2, 6, 0x404040);
		f_96547_.m_92883_(poseStack, menu.inventory.m_5446_().getString(), menu.getPlayerInvX(), menu.getPlayerInvY()-11, 0x404040);
		if(mouseX-f_97735_ >= 10 && mouseY-f_97736_ >= 10 && mouseX-f_97735_ <= 21 && mouseY-f_97736_ <= 49) {
			m_96602_(poseStack, Component.m_237113_(menu.blockEntity.getEnergyStorage().getEnergyStored()+" / "+menu.blockEntity.getEnergyStorage().getMaxEnergyStored()+" FE"), mouseX-f_97735_, mouseY-f_97736_);
		}
		for(GuiEventListener child : m_6702_()) {
			if(child.m_5953_(mouseX, mouseY) && child instanceof AbstractWidget button) {
				button.m_7428_(poseStack, mouseX-f_97735_, mouseY-f_97736_);
				break;
			}
		}
		super.m_7027_(poseStack, mouseX, mouseY);
	}

	class ButtonChangeBlocking extends AbstractWidget {

		public ButtonChangeBlocking(int x, int y) {
			super(x, y, 16, 18, Component.m_237119_());
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93228_(poseStack, f_93620_+1, f_93621_+2, 176, menu.blockEntity.blocking ? 64 : 50, 14, 14);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, Component.m_237115_("block.packagedauto.unpackager.blocking."+menu.blockEntity.blocking), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(ChangeBlockingPacket.INSTANCE);
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonTracker extends AbstractWidget {

		final int id;

		ButtonTracker(int id, int x, int y) {
			super(x, y, 54, 5, Component.m_237119_());
			this.id = id;
		}

		@Override
		public void m_6303_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			Component line0 = Component.m_237110_("block.packagedauto.unpackager.tracker", id);
			Component line1 = Component.m_237115_("block.packagedauto.unpackager.tracker.eject").m_130940_(ChatFormatting.GRAY);
			m_96597_(poseStack, Arrays.asList(line0, line1), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			if(m_96638_()) {
				PacketHandler.INSTANCE.sendToServer(new EjectTrackerPacket(id));
			}
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}

	class ButtonTrackerCount extends AbstractWidget {

		final boolean decrease;

		public ButtonTrackerCount(boolean decrease, int x, int y) {
			super(x, y, 8, 18, Component.m_237119_());
			this.decrease = decrease;
		}

		@Override
		protected void m_7906_(PoseStack poseStack, Minecraft minecraft, int mouseX, int mouseY) {
			RenderSystem.m_157429_(1F, 1F, 1F, 1F);
			RenderSystem.m_157456_(0, BACKGROUND);
			m_93228_(poseStack, f_93620_+1, f_93621_+2, decrease ? 176 : 182, 78, 6, 14);
		}

		@Override
		public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
			m_96602_(poseStack, Component.m_237115_("block.packagedauto.unpackager.tracker."+(decrease ? "decrease" : "increase")), mouseX, mouseY);
		}

		@Override
		public void m_5716_(double mouseX, double mouseY) {
			PacketHandler.INSTANCE.sendToServer(new TrackerCountPacket(decrease));
		}

		@Override
		public void m_142291_(NarrationElementOutput narrationElementOutput) {}
	}
}
