package thelm.packagedauto.integration.emi;

import java.util.List;
import java.util.Optional;

import com.mojang.blaze3d.vertex.PoseStack;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.client.screen.EncoderScreen;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.SetItemStackPacket;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.ApiImpl;
import thelm.packagedauto.util.MiscHelper;

public class EncoderDragDropHandler implements EmiDragDropHandler<EncoderScreen> {

	@Override
	public boolean dropStack(EncoderScreen gui, EmiIngredient ingredient, int x, int y) {
		ItemStack stack = wrapStack(ingredient);
		if(stack.m_41619_()) {
			return false;
		}
		for(SlotTarget target : getTargets(gui, ingredient)) {
			if(target.getBounds().contains(x, y)) {
				target.accept(ingredient);
				return true;
			}
		}
		return false;
	}

	@Override
	public void render(EncoderScreen gui, EmiIngredient ingredient, PoseStack poseStack, int mouseX, int mouseY, float delta) {
		ItemStack stack = wrapStack(ingredient);
		if(stack.m_41619_()) {
			return;
		}
		for(SlotTarget target : getTargets(gui, ingredient)) {
			Bounds bounds = target.getBounds();
			GuiComponent.m_93172_(poseStack, bounds.left(), bounds.top(), bounds.right(), bounds.bottom(), 0x8822BB33);
		}
	}

	public List<SlotTarget> getTargets(EncoderScreen gui, EmiIngredient ingredient) {
		ItemStack stack = wrapStack(ingredient);
		if(!stack.m_41619_()) {
			return gui.menu.f_38839_.stream().filter(s->s instanceof FalseCopySlot).
					map(s->new SlotTarget(s, getSlotBounds(gui, s))).toList();
		}
		return List.of();
	}

	private static Bounds getSlotBounds(AbstractContainerScreen<?> gui, Slot slot) {
		return new Bounds(gui.getGuiLeft()+slot.f_40220_, gui.getGuiTop()+slot.f_40221_, 16, 16);
	}

	private static ItemStack wrapStack(EmiIngredient emiIngredient) {
		Optional<?> ingredient = PackagedAutoEMIPlugin.toStack(PackagedAutoEMIPlugin.getTreeEmiStack(emiIngredient));
		if(ingredient.isEmpty()) {
			return ItemStack.f_41583_;
		}
		if(ingredient.get() instanceof ItemStack stack) {
			return stack;
		}
		IVolumeType type = ApiImpl.INSTANCE.getVolumeType(ingredient.get().getClass());
		if(type != null) {
			return MiscHelper.INSTANCE.tryMakeVolumePackage(ingredient.get());
		}
		return ItemStack.f_41583_;
	}

	private static record SlotTarget(Slot slot, Bounds bounds) {

		public Bounds getBounds() {
			return bounds;
		}

		public void accept(EmiIngredient emiIngredient) {
			ItemStack stack = wrapStack(emiIngredient);
			if(!stack.m_41619_()) {
				PacketHandler.INSTANCE.sendToServer(new SetItemStackPacket(slot.f_40219_, stack));
			}
		}
	}
}
