package thelm.packagedauto.item;

import java.util.List;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeList;
import thelm.packagedauto.api.IPackageRecipeListItem;
import thelm.packagedauto.api.IVolumePackageItem;
import thelm.packagedauto.api.IVolumeStackWrapper;
import thelm.packagedauto.util.PackageRecipeList;

public class RecipeHolderItem extends Item implements IPackageRecipeListItem {

	public static final RecipeHolderItem INSTANCE = new RecipeHolderItem();

	protected RecipeHolderItem() {
		super(new Item.Properties().m_41491_(PackagedAuto.CREATIVE_TAB));
	}

	@Override
	public IPackageRecipeList getRecipeList(ItemStack stack) {
		return new PackageRecipeList(stack.m_41783_());
	}

	@Override
	public void setRecipeList(ItemStack stack, IPackageRecipeList recipeList) {
		stack.m_41784_().m_128473_("Recipes");
		if(recipeList != null) {
			recipeList.save(stack.m_41783_());
		}
		if(stack.m_41783_().m_128456_()) {
			stack.m_41751_(null);
		}
	}

	@Override
	public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
		if(!level.f_46443_ && player.m_6144_() && isFilled(player.m_21120_(hand))) {
			ItemStack stack = player.m_21120_(hand).m_41777_();
			setRecipeList(stack, null);
			return InteractionResultHolder.m_19090_(stack);
		}
		return super.m_7203_(level, player, hand);
	}

	@Override
	public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
		if(stack.m_41782_()) {
			List<IPackageRecipeInfo> recipeList = getRecipeList(stack).getRecipeList();
			tooltip.add(Component.m_237115_("item.packagedauto.recipe_holder.recipes"));
			for(IPackageRecipeInfo recipe : recipeList) {
				MutableComponent component = recipe.getRecipeType().getDisplayName().m_130946_(": ");
				for(int i = 0; i < recipe.getOutputs().size(); ++i) {
					if(i != 0) {
						component.m_130946_(", ");
					}
					ItemStack is = recipe.getOutputs().get(i);
					if(is.m_41720_() instanceof IVolumePackageItem vp) {
						IVolumeStackWrapper vs = vp.getVolumeStack(is);
						component.m_130946_(is.m_41613_()+"x").m_7220_(vs.getAmountDesc()).m_130946_(" ").
						m_7220_(ComponentUtils.m_130748_(vs.getDisplayName()));
					}
					else {
						component.m_130946_(is.m_41613_()+" ").m_7220_(is.m_41611_());
					}
				}
				tooltip.add(component);
			}
		}
		super.m_7373_(stack, level, tooltip, isAdvanced);
	}

	public boolean isFilled(ItemStack stack) {
		CompoundTag nbt = stack.m_41783_();
		return nbt != null && !nbt.m_128437_("Recipes", 10).isEmpty();
	}
}
