package thelm.packagedauto.network.packet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.network.PacketHandler;

public record DirectionalMarkerPacket(List<DirectionalGlobalPos> positions, int color, int lifetime) {

	public void encode(FriendlyByteBuf buf) {
		buf.writeByte(positions.size());
		for(DirectionalGlobalPos globalPos : positions) {
			buf.m_130085_(globalPos.dimension().m_135782_());
			buf.writeInt(globalPos.x());
			buf.writeInt(globalPos.y());
			buf.writeInt(globalPos.z());
			buf.writeByte(globalPos.direction().m_122411_());
		}
		buf.writeMedium(color);
		buf.writeShort(lifetime);
	}

	public static DirectionalMarkerPacket decode(FriendlyByteBuf buf) {
		int size = buf.readByte();
		List<DirectionalGlobalPos> positions = new ArrayList<>(size);
		for(int i = 0; i < size; ++i) {
			ResourceKey<Level> dimension = ResourceKey.m_135785_(Registry.f_122819_, buf.m_130281_());
			BlockPos pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
			Direction direction = Direction.m_122376_(buf.readByte());
			positions.add(new DirectionalGlobalPos(dimension, pos, direction));
		}
		return new DirectionalMarkerPacket(positions, buf.readUnsignedMedium(), buf.readUnsignedShort());
	}

	public void handle(Supplier<NetworkEvent.Context> ctx) {
		ctx.get().enqueueWork(()->{
			WorldOverlayRenderer.INSTANCE.addDirectionalMarkers(positions, color, lifetime);
		});
		ctx.get().setPacketHandled(true);
	}

	public static void sendDirectionalMarkers(ServerPlayer player, List<DirectionalGlobalPos> positions, int color, int lifetime) {
		PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(()->player), new DirectionalMarkerPacket(positions, color, lifetime));
	}
}
