package thelm.packagedauto.util;

import java.util.OptionalInt;

import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;

public abstract class OptionalIntDataSlot extends DataSlot {

	private OptionalInt prevValue = OptionalInt.empty();

	public static OptionalIntDataSlot of(ContainerData data, final int id) {
		return new OptionalIntDataSlot() {
			@Override
			public int m_6501_() {
				return data.m_6413_(id);
			}
			@Override
			public void m_6422_(int value) {
				data.m_8050_(id, value);
			}
		};
	}

	public static OptionalIntDataSlot of(int[] data, final int id) {
		return new OptionalIntDataSlot() {
			@Override
			public int m_6501_() {
				return data[id];
			}
			@Override
			public void m_6422_(int value) {
				data[id] = value;
			}
		};
	}

	public static OptionalIntDataSlot of() {
		return new OptionalIntDataSlot() {
			private int value;
			@Override
			public int m_6501_() {
				return value;
			}
			@Override
			public void m_6422_(int value) {
				this.value = value;
			}
		};
	}

	public boolean m_39409_() {
		int i = m_6501_();
		boolean flag = prevValue.isEmpty() || i != prevValue.getAsInt();
		prevValue = OptionalInt.of(i);
		return flag;
	}
}
