package thelm.packagedauto.block;

import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileCrafter;

public class BlockCrafter extends BlockBase {

	public static final BlockCrafter INSTANCE = new BlockCrafter();
	public static final Item ITEM_INSTANCE = new ItemBlock(INSTANCE).setRegistryName("packagedauto:crafter");
	public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:crafter#normal");

	protected BlockCrafter() {
		super(Material.field_151573_f);
		func_149711_c(15F);
		func_149752_b(25F);
		func_149672_a(SoundType.field_185852_e);
		func_149663_c("packagedauto.crafter");
		setRegistryName("packagedauto:crafter");
		func_149647_a(PackagedAuto.CREATIVE_TAB);
	}

	@Override
	public TileBase func_149915_a(World worldIn, int meta) {
		return new TileCrafter();
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModels() {
		ModelLoader.setCustomModelResourceLocation(ITEM_INSTANCE, 0, MODEL_LOCATION);
	}
}
