package thelm.packagedauto.block;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TileDistributor;

public class BlockDistributor extends BlockBase {

	public static final BlockDistributor INSTANCE = new BlockDistributor();
	public static final Item ITEM_INSTANCE = new ItemBlock(INSTANCE).setRegistryName("packagedauto:distributor");
	public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:distributor#normal");

	protected BlockDistributor() {
		super(Material.field_151573_f);
		func_149711_c(15F);
		func_149752_b(25F);
		func_149672_a(SoundType.field_185852_e);
		func_149663_c("packagedauto.distributor");
		setRegistryName("packagedauto:distributor");
		func_149647_a(PackagedAuto.CREATIVE_TAB);
	}

	@Override
	public TileBase func_149915_a(World worldIn, int meta) {
		return new TileDistributor();
	}

	@Override
	public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
		if(playerIn.func_70093_af()) {
			TileEntity tileentity = worldIn.func_175625_s(pos);
			if(tileentity instanceof TileDistributor) {
				if(!worldIn.field_72995_K) {
					((TileDistributor)tileentity).sendPreview((EntityPlayerMP)playerIn);
				}
				return true;
			}
		}
		return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
	}

	@Override
	public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
		TileEntity tileentity = worldIn.func_175625_s(pos);
		if(tileentity instanceof TileDistributor) {
			for(Int2ObjectMap.Entry<ItemStack> entry : ((TileDistributor)tileentity).pending.int2ObjectEntrySet()) {
				InventoryHelper.func_180173_a(worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entry.getValue());
			}
		}
		super.func_180663_b(worldIn, pos, state);
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModels() {
		ModelLoader.setCustomModelResourceLocation(ITEM_INSTANCE, 0, MODEL_LOCATION);
	}
}
