package thelm.packagedauto.client.gui;

import java.io.IOException;

import org.lwjgl.input.Keyboard;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import thelm.packagedauto.container.ContainerTileBase;

// Code from Refined Storage
public abstract class GuiAmountSpecifying<C extends ContainerTileBase<?>> extends GuiContainerTileBase<C> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/amount_specifying.png");

	private GuiContainerTileBase<?> parent;

	protected GuiTextField amountField;

	public GuiAmountSpecifying(GuiContainerTileBase<?> parent, C container) {
		super(container);
		field_146999_f = 172;
		field_147000_g = 99;
		this.parent = parent;
	}

	protected abstract int getDefaultAmount();

	protected abstract int getMaxAmount();

	protected abstract int[] getIncrements();

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void func_73866_w_() {
		field_146292_n.clear();
		super.func_73866_w_();
		field_146297_k.field_71439_g.field_71070_bA = parent.field_147002_h;

		func_189646_b(new ButtonSet(0, field_147003_i+114, field_147009_r+22, I18n.func_74838_a("misc.packagedauto.set")));
		func_189646_b(new ButtonCancel(0, field_147003_i+114, field_147009_r+22+24, I18n.func_74838_a("gui.cancel")));

		amountField = new GuiTextField(0, field_146289_q, field_147003_i+9, field_147009_r+51, 63, field_146289_q.field_78288_b);
		amountField.func_146185_a(false);
		amountField.func_146180_a(String.valueOf(getDefaultAmount()));
		amountField.func_146193_g(0xFFFFFF);
		amountField.func_175205_a(s->{
			if(s.isEmpty()) {
				return true;
			}
			try {
				int amount = Integer.parseInt(s);
				return amount >= 0 && amount <= getMaxAmount();
			}
			catch(NumberFormatException e) {
				return false;
			}
		});

		int[] increments = getIncrements();
		int xx = 7;
		for(int i = 0; i < 3; ++i) {
			int increment = increments[i];
			String text = "+" + increment;
			func_189646_b(new ButtonIncrement(i, field_147003_i+xx, field_147009_r+20, text));
			xx += 34;
		}
		xx = 7;
		for(int i = 0; i < 3; ++i) {
			int increment = increments[i];
			String text = "-" + increment;
			func_189646_b(new ButtonIncrement(i+3, field_147003_i+xx, field_147009_r+field_147000_g-20-7, text));
			xx += 34;
		}
	}

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		super.func_146976_a(partialTicks, mouseX, mouseY);
		amountField.func_146194_f();
	}

	@Override
	protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
		super.func_73864_a(mouseX, mouseY, mouseButton);
		amountField.func_146192_a(mouseX, mouseY, mouseButton);
	}

	@Override
	protected void func_73869_a(char typedChar, int keyCode) throws IOException {
		if(keyCode == Keyboard.KEY_ESCAPE) {
			close();
			return;
		}
		if((keyCode == Keyboard.KEY_RETURN || keyCode == Keyboard.KEY_NUMPADENTER) && amountField.func_146206_l()) {
			onOkButtonPressed(func_146272_n());
			return;
		}
		if(amountField.func_146201_a(typedChar, keyCode)) {
			return;
		}
		if(field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode) && amountField.func_146206_l()) {
			return;
		}
		super.func_73869_a(typedChar, keyCode);
	}

	@Override
	protected void func_146284_a(GuiButton button) throws IOException {
		if(button instanceof ButtonSet) {
			onOkButtonPressed(func_146272_n());
		}
		if(button instanceof ButtonCancel) {
			close();
		}
		if(button instanceof ButtonIncrement) {
			int increment = getIncrements()[button.field_146127_k % 3];
			onIncrementButtonClicked(increment * (button.field_146127_k / 3 == 0 ? 1 : -1));
		}
	}

	protected void onIncrementButtonClicked(int increment) {
		int oldAmount = 0;
		try {
			oldAmount = Integer.parseInt(amountField.func_146179_b());
		}
		catch(NumberFormatException e) {
			// NO OP
		}
		int newAmount = MathHelper.func_76125_a(oldAmount+increment, 0, getMaxAmount());
		amountField.func_146180_a(String.valueOf(newAmount));
	}

	protected abstract void onOkButtonPressed(boolean shiftDown);

	public void close() {
		field_146297_k.func_147108_a(parent);
	}

	public GuiContainerTileBase<?> getParent() {
		return parent;
	}

	static class ButtonSet extends GuiButton {

		public ButtonSet(int buttonId, int x, int y, String text) {
			super(buttonId, x, y, 50, 20, text);
		}
	}

	static class ButtonCancel extends GuiButton {

		public ButtonCancel(int buttonId, int x, int y, String text) {
			super(buttonId, x, y, 50, 20, text);
		}
	}

	static class ButtonIncrement extends GuiButton {

		public ButtonIncrement(int buttonId, int x, int y, String text) {
			super(buttonId, x, y, 34, 20, text);
		}
	}
}
