package thelm.packagedauto.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.Loader;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.container.ContainerEncoder;
import thelm.packagedauto.integration.jei.PackagedAutoJEIPlugin;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketCycleRecipeType;
import thelm.packagedauto.network.packet.PacketLoadRecipeList;
import thelm.packagedauto.network.packet.PacketSaveRecipeList;
import thelm.packagedauto.network.packet.PacketSetPatternIndex;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class GuiEncoder extends GuiContainerTileBase<ContainerEncoder> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/encoder.png");

	public GuiEncoder(ContainerEncoder container) {
		super(container);
		field_146999_f = 258;
		field_147000_g = 314;
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void func_73866_w_() {
		field_146292_n.clear();
		super.func_73866_w_();
		int patternSlots = container.tile.patternInventories.length;
		for(int i = 0; i < patternSlots; ++i) {
			func_189646_b(new GuiButtonPatternSlot(i, field_147003_i+30+(i%10)*18, field_147009_r+(patternSlots > 10 ? 16 : 25)+(i/10)*18));
		}
		func_189646_b(new GuiButtonRecipeType(0, field_147003_i+189, field_147009_r+74));
		func_189646_b(new GuiButtonRecipeType(1, field_147003_i+225, field_147009_r+74));
		func_189646_b(new GuiButtonSavePatterns(0, field_147003_i+215, field_147009_r+16));
		func_189646_b(new GuiButtonLoadPatterns(0, field_147003_i+215, field_147009_r+34));
		func_189646_b(new GuiButtonClearPatterns(0, field_147003_i+171, field_147009_r+56));
		if(Loader.isModLoaded("jei")) {
			func_189646_b(new GuiButtonShowRecipesJEI(0, field_147003_i+172, field_147009_r+129));
		}
	}

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		super.func_146976_a(partialTicks, mouseX, mouseY);
		IRecipeType recipeType = container.patternInventory.recipeType;
		for(int i = 0; i < 9; ++i) {
			for(int j = 0; j < 9; ++j) {
				Color color = recipeType.getSlotColor(i*9+j);
				GlStateManager.func_179131_c(color.getRed()/255F, color.getGreen()/255F, color.getBlue()/255F, color.getAlpha()/255F);
				func_146110_a(field_147003_i+8+j*18, field_147009_r+57+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		for(int i = 0; i < 3; ++i) {
			for(int j = 0; j < 3; ++j) {
				Color color = recipeType.getSlotColor(81+i*3+j);
				GlStateManager.func_179131_c(color.getRed()/255F, color.getGreen()/255F, color.getBlue()/255F, 1);
				func_146110_a(field_147003_i+198+j*18, field_147009_r+111+i*18, 258, 0, 16, 16, 512, 512);
			}
		}
		GlStateManager.func_179131_c(1, 1, 1, 1);
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		String s = container.inventory.func_145748_c_().func_150260_c();
		field_146289_q.func_78276_b(s, field_146999_f/2 - field_146289_q.func_78256_a(s)/2, 6, 0x404040);
		field_146289_q.func_78276_b(container.playerInventory.func_145748_c_().func_150260_c(), container.getPlayerInvX(), container.getPlayerInvY()-11, 0x404040);
		String str = field_146289_q.func_78269_a(container.patternInventory.recipeType.getLocalizedNameShort(), 86);
		field_146289_q.func_78276_b(str, 212 - field_146289_q.func_78256_a(str)/2, 64, 0x404040);
		IRecipeType recipeType = container.patternInventory.recipeType;
		if(recipeType != null) {
			Object rep = recipeType.getRepresentation();
			if(rep instanceof TextureAtlasSprite) {
				GlStateManager.func_179131_c(1, 1, 1, 1);
				field_146297_k.field_71446_o.func_110577_a(TextureMap.field_110575_b);
				func_175175_a(204, 75, (TextureAtlasSprite)rep, 16, 16);
			}
			if(rep instanceof ItemStack) {
				RenderHelper.func_74520_c();
				GlStateManager.func_179131_c(1, 1, 1, 1);
				field_146297_k.func_175599_af().func_175042_a((ItemStack)rep, 204, 75);
				RenderHelper.func_74518_a();
			}
		}
		for(GuiButton guibutton : field_146292_n) {
			if(guibutton.func_146115_a()) {
				guibutton.func_146111_b(mouseX-field_147003_i, mouseY-field_147009_r);
				break;
			}
		}
	}

	@Override
	public int getItemAmountSpecificationLimit(Slot slot) {
		int stackLimit = slot.func_75211_c().func_77976_d();
		return slot.field_75222_d > 81 ? Math.max(stackLimit, 999) : stackLimit;
	}

	@Override
	protected void func_146284_a(GuiButton button) throws IOException {
		if(button instanceof GuiButtonPatternSlot) {
			PacketHandler.INSTANCE.sendToServer(new PacketSetPatternIndex(button.field_146127_k));
			container.tile.setPatternIndex(button.field_146127_k);
			container.setupSlots();
		}
		if(button instanceof GuiButtonRecipeType) {
			PacketHandler.INSTANCE.sendToServer(new PacketCycleRecipeType(button.field_146127_k == 0));
			container.patternInventory.cycleRecipeType(button.field_146127_k == 0);
			container.setupSlots();
		}
		if(button instanceof GuiButtonSavePatterns) {
			boolean single = func_146272_n();
			PacketHandler.INSTANCE.sendToServer(new PacketSaveRecipeList(single));
		}
		if(button instanceof GuiButtonLoadPatterns) {
			boolean single = func_146272_n();
			PacketHandler.INSTANCE.sendToServer(new PacketLoadRecipeList(single, false));
			container.tile.loadRecipeList(single, false);
			container.setupSlots();
		}
		if(button instanceof GuiButtonClearPatterns) {
			boolean single = !func_146272_n();
			PacketHandler.INSTANCE.sendToServer(new PacketLoadRecipeList(single, true));
			container.tile.loadRecipeList(single, true);
			container.setupSlots();
		}
		if(button instanceof GuiButtonShowRecipesJEI) {
			MiscUtil.conditionalRunnable(()->true, ()->()->{
				IRecipeType recipeType = container.patternInventory.recipeType;
				if(recipeType != null) {
					PackagedAutoJEIPlugin.showCategories(recipeType.getJEICategories());
				}
			}, ()->()->{}).run();
		}
	}

	class GuiButtonPatternSlot extends GuiButton {

		GuiButtonPatternSlot(int buttonId, int x, int y) {
			super(buttonId, x, y, 18, 18, "");
		}

		@Override
		protected int func_146114_a(boolean mouseOver) {
			if(container.tile.patternIndex == field_146127_k) {
				return 2;
			}
			return super.func_146114_a(mouseOver);
		}

		@Override
		protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
			for(int i = 81; i < 90; ++i) {
				ItemStack stack = container.tile.patternInventories[field_146127_k].stacks.get(i);
				if(!stack.func_190926_b()) {
					RenderHelper.func_74520_c();
					GlStateManager.func_179131_c(1, 1, 1, 1);
					mc.func_175599_af().func_175042_a(stack, field_146128_h+1, field_146129_i+1);
					RenderHelper.func_74518_a();
					break;
				}
			}
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			func_146279_a(I18n.func_74837_a("tile.packagedauto.encoder.pattern_slot", String.format("%02d", field_146127_k)), mouseX, mouseY);
		}
	}

	class GuiButtonRecipeType extends GuiButton {

		GuiButtonRecipeType(int buttonId, int x, int y) {
			super(buttonId, x, y, 10, 18, "");
		}

		@Override
		protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
			GlStateManager.func_179131_c(1, 1, 1, 1);
			mc.field_71446_o.func_110577_a(BACKGROUND);
			func_146110_a(field_146128_h+1, field_146129_i+1, field_146127_k == 0 ? 258 : 266, 48, 8, 16, 512, 512);
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			func_146279_a(I18n.func_74838_a("tile.packagedauto.encoder.recipe_type."+(field_146127_k == 0 ? "prev" : "next")), mouseX, mouseY);
		}
	}

	class GuiButtonSavePatterns extends GuiButton {

		GuiButtonSavePatterns(int buttonId, int x, int y) {
			super(buttonId, x, y, 36, 18, "");
		}

		@Override
		protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
			GlStateManager.func_179131_c(1, 1, 1, 1);
			mc.field_71446_o.func_110577_a(BACKGROUND);
			func_146110_a(field_146128_h+1, field_146129_i+1, 258, 16, 34, 16, 512, 512);
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			String line0 = I18n.func_74838_a("tile.packagedauto.encoder.save");
			String line1 = TextFormatting.GRAY+I18n.func_74838_a("tile.packagedauto.encoder.save.single");
			func_146283_a(Arrays.asList(line0, line1), mouseX, mouseY);
		}
	}

	class GuiButtonLoadPatterns extends GuiButton {

		GuiButtonLoadPatterns(int buttonId, int x, int y) {
			super(buttonId, x, y, 36, 18, "");
		}

		@Override
		protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
			GlStateManager.func_179131_c(1, 1, 1, 1);
			mc.field_71446_o.func_110577_a(BACKGROUND);
			func_146110_a(field_146128_h+1, field_146129_i+1, 258, 32, 34, 16, 512, 512);
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			String line0 = I18n.func_74838_a("tile.packagedauto.encoder.load");
			String line1 = TextFormatting.GRAY+I18n.func_74838_a("tile.packagedauto.encoder.load.single");
			func_146283_a(Arrays.asList(line0, line1), mouseX, mouseY);
		}
	}

	class GuiButtonClearPatterns extends GuiButton {

		GuiButtonClearPatterns(int buttonId, int x, int y) {
			super(buttonId, x, y, 7, 7, "");
		}

		@Override
		public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
			if(field_146125_m) {
				field_146123_n = mouseX >= field_146128_h && mouseY >= field_146129_i && mouseX < field_146128_h + field_146120_f && mouseY < field_146129_i + field_146121_g;
			}
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			String line0 = I18n.func_74838_a("tile.packagedauto.encoder.clear");
			String line1 = TextFormatting.GRAY+I18n.func_74838_a("tile.packagedauto.encoder.clear.all");
			func_146283_a(Arrays.asList(line0, line1), mouseX, mouseY);
		}
	}

	class GuiButtonShowRecipesJEI extends GuiButton {

		GuiButtonShowRecipesJEI(int buttonId, int x, int y) {
			super(buttonId, x, y, 22, 16, "");
		}

		@Override
		public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
			if(field_146125_m) {
				field_146123_n = mouseX >= field_146128_h && mouseY >= field_146129_i && mouseX < field_146128_h + field_146120_f && mouseY < field_146129_i + field_146121_g;
			}
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			IRecipeType recipeType = container.patternInventory.recipeType;
			if(recipeType != null && !recipeType.getJEICategories().isEmpty()) {
				func_146279_a(I18n.func_74838_a("jei.tooltip.show.recipes"), mouseX, mouseY);
			}
		}
	}
}
