package thelm.packagedauto.client.gui;

import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import thelm.packagedauto.container.ContainerItemAmountSpecifying;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketSetItemStack;

public class GuiItemAmountSpecifying extends GuiAmountSpecifying<ContainerItemAmountSpecifying> {

	private int containerSlot;
	private ItemStack stack;
	private int maxAmount;

	public GuiItemAmountSpecifying(GuiContainerTileBase<?> parent, InventoryPlayer playerInventory, int containerSlot, ItemStack stack, int maxAmount) {
		super(parent, new ContainerItemAmountSpecifying(playerInventory, stack));
		this.containerSlot = containerSlot;
		this.stack = stack;
		this.maxAmount = maxAmount;
	}

	@Override
	protected int getDefaultAmount() {
		return stack.func_190916_E();
	}

	@Override
	protected int getMaxAmount() {
		return maxAmount;
	}

	@Override
	protected int[] getIncrements() {
		return new int[] {
				1, 10, 64,
		};
	}

	@Override
	protected void func_146979_b(int x, int y) {
		field_146289_q.func_78276_b(I18n.func_74838_a("gui.packagedauto.item_amount_specifying"), 7, 7, 0x404040);
		super.func_146979_b(x, y);
	}

	@Override
	protected void onOkButtonPressed(boolean shiftDown) {
		try {
			int amount = MathHelper.func_76125_a(Integer.parseInt(amountField.func_146179_b()), 0, maxAmount);
			ItemStack newStack = stack.func_77946_l();
			newStack.func_190920_e(amount);
			PacketHandler.INSTANCE.sendToServer(new PacketSetItemStack((short)containerSlot, newStack));
			close();
		}
		catch(NumberFormatException e) {
			// NO OP
		}
	}
}
