package thelm.packagedauto.client.gui;

import java.io.IOException;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import thelm.packagedauto.container.ContainerPackagerExtension;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketChangePackaging;

public class GuiPackagerExtension extends GuiContainerTileBase<ContainerPackagerExtension> {

	public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/packager_extension.png");

	public GuiPackagerExtension(ContainerPackagerExtension container) {
		super(container);
	}

	@Override
	protected ResourceLocation getBackgroundTexture() {
		return BACKGROUND;
	}

	@Override
	public void func_73866_w_() {
		field_146292_n.clear();
		super.func_73866_w_();
		func_189646_b(new ButtonChangePackaging(0, field_147003_i+98, field_147009_r+16));
	}

	@Override
	protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
		super.func_146976_a(partialTicks, mouseX, mouseY);
		func_73729_b(field_147003_i+102, field_147009_r+53, 176, 0, container.tile.getScaledProgress(22), 16);
		int scaledEnergy = container.tile.getScaledEnergy(40);
		func_73729_b(field_147003_i+10, field_147009_r+10+40-scaledEnergy, 176, 16+40-scaledEnergy, 12, scaledEnergy);
	}

	@Override
	protected void func_146979_b(int mouseX, int mouseY) {
		super.func_146979_b(mouseX, mouseY);
		String s = container.inventory.func_145748_c_().func_150260_c();
		field_146289_q.func_78276_b(s, field_146999_f/2 - field_146289_q.func_78256_a(s)/2, 6, 0x404040);
		field_146289_q.func_78276_b(container.playerInventory.func_145748_c_().func_150260_c(), container.getPlayerInvX(), container.getPlayerInvY()-11, 0x404040);
		if(mouseX-field_147003_i >= 10 && mouseY-field_147009_r >= 10 && mouseX-field_147003_i <= 21 && mouseY-field_147009_r <= 49) {
			func_146279_a(container.tile.getEnergyStorage().getEnergyStored()+" / "+container.tile.getEnergyStorage().getMaxEnergyStored()+" FE", mouseX-field_147003_i, mouseY-field_147009_r);
		}
		for(GuiButton guibutton : field_146292_n) {
			if(guibutton.func_146115_a()) {
				guibutton.func_146111_b(mouseX-field_147003_i, mouseY-field_147009_r);
				break;
			}
		}
	}

	@Override
	protected void func_146284_a(GuiButton button) throws IOException {
		if(button instanceof ButtonChangePackaging) {
			PacketHandler.INSTANCE.sendToServer(new PacketChangePackaging());
		}
	}

	class ButtonChangePackaging extends GuiButton {

		ButtonChangePackaging(int buttonId, int x, int y) {
			super(buttonId, x, y, 16, 18, "");
		}

		@Override
		protected void func_146119_b(Minecraft mc, int mouseX, int mouseY) {
			GlStateManager.func_179131_c(1, 1, 1, 1);
			mc.field_71446_o.func_110577_a(BACKGROUND);
			func_73729_b(field_146128_h+1, field_146129_i+2, 176, 56+14*container.tile.mode.ordinal(), 14, 14);
		}

		@Override
		public void func_146111_b(int mouseX, int mouseY) {
			func_146279_a(container.tile.mode.getTooltip(), mouseX, mouseY);
		}
	}
}
