package thelm.packagedauto.container;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntRBTreeMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.inventory.InventoryTileBase;
import thelm.packagedauto.slot.SlotFalseCopy;
import thelm.packagedauto.tile.TileBase;

//Large portions of code are taken from CoFHCore
public class ContainerTileBase<TILE extends TileBase> extends Container {

	public final TILE tile;
	public final InventoryPlayer playerInventory;
	public final InventoryTileBase inventory;
	public final Int2IntMap prevSyncValues = new Int2IntRBTreeMap();

	public ContainerTileBase(InventoryPlayer playerInventory, TILE tile) {
		this.tile = tile;
		this.playerInventory = playerInventory;
		this.inventory = tile != null ? tile.getInventory() : new InventoryTileBase(null, 0);
	}

	public int getPlayerInvX() {
		return 8;
	}

	public int getPlayerInvY() {
		return 84;
	}

	public void setupPlayerInventory() {
		int xOffset = getPlayerInvX();
		int yOffset = getPlayerInvY();
		for(int i = 0; i < 3; i++) {
			for(int j = 0; j < 9; j++) {
				func_75146_a(new Slot(playerInventory, j+i*9+9, xOffset+j*18, yOffset+i*18));
			}
		}
		for(int i = 0; i < 9; i++) {
			func_75146_a(new Slot(playerInventory, i, xOffset+i*18, yOffset+58));
		}
	}

	public int getSizeInventory() {
		return inventory.func_70302_i_();
	}

	public boolean supportsShiftClick(EntityPlayer player, int slotIndex) {
		return true;
	}

	public boolean performMerge(EntityPlayer player, int slotIndex, ItemStack stack) {
		int invBase = getSizeInventory();
		int invFull = field_75151_b.size();
		if(slotIndex < invBase) {
			return func_75135_a(stack, invBase, invFull, true);
		}
		return func_75135_a(stack, 0, invBase, false);
	}

	@Override
	public ItemStack func_82846_b(EntityPlayer player, int slotIndex) {
		if(!supportsShiftClick(player, slotIndex)) {
			return ItemStack.field_190927_a;
		}
		ItemStack stack = ItemStack.field_190927_a;
		Slot slot = field_75151_b.get(slotIndex);
		if(slot != null && slot.func_75216_d()) {
			ItemStack stackInSlot = slot.func_75211_c();
			stack = stackInSlot.func_77946_l();
			if(!performMerge(player, slotIndex, stackInSlot)) {
				return ItemStack.field_190927_a;
			}
			slot.func_75220_a(stackInSlot, stack);
			if(stackInSlot.func_190916_E() <= 0) {
				slot.func_75215_d(ItemStack.field_190927_a);
			}
			else {
				slot.func_75215_d(stackInSlot);
			}
			if(stackInSlot.func_190916_E() == stack.func_190916_E()) {
				return ItemStack.field_190927_a;
			}
			slot.func_190901_a(player, stackInSlot);
		}
		return stack;
	}

	@Override
	protected boolean func_75135_a(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
		boolean successful = false;
		int i = !ascending ? slotMin : slotMax - 1;
		int iterOrder = !ascending ? 1 : -1;
		Slot slot;
		ItemStack existingStack;
		if(stack.func_77985_e()) {
			while(stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
				slot = field_75151_b.get(i);
				if(slot instanceof SlotFalseCopy) {
					i += iterOrder;
					continue;
				}
				existingStack = slot.func_75211_c();
				if(!existingStack.func_190926_b()) {
					int maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a());
					int rmv = Math.min(maxStack, stack.func_190916_E());
					if(slot.func_75214_a(MiscUtil.cloneStack(stack, rmv)) && existingStack.func_77973_b().equals(stack.func_77973_b()) && (!stack.func_77981_g() || stack.func_77952_i() == existingStack.func_77952_i()) && ItemStack.func_77970_a(stack, existingStack)) {
						int existingSize = existingStack.func_190916_E() + stack.func_190916_E();
						if(existingSize <= maxStack) {
							stack.func_190920_e(0);
							existingStack.func_190920_e(existingSize);
							slot.func_75215_d(existingStack);
							successful = true;
						}
						else if(existingStack.func_190916_E() < maxStack) {
							stack.func_190918_g(maxStack - existingStack.func_190916_E());
							existingStack.func_190920_e(maxStack);
							slot.func_75215_d(existingStack);
							successful = true;
						}
					}
				}
				i += iterOrder;
			}
		}
		if(stack.func_190916_E() > 0) {
			i = !ascending ? slotMin : slotMax - 1;
			while(stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
				slot = field_75151_b.get(i);
				if(slot instanceof SlotFalseCopy) {
					i += iterOrder;
					continue;
				}
				existingStack = slot.func_75211_c();
				if(existingStack.func_190926_b()) {
					int maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a());
					int rmv = Math.min(maxStack, stack.func_190916_E());
					if(slot.func_75214_a(MiscUtil.cloneStack(stack, rmv))) {
						existingStack = stack.func_77979_a(rmv);
						slot.func_75215_d(existingStack);
						successful = true;
					}
				}
				i += iterOrder;
			}
		}
		return successful;
	}

	@Override
	public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, EntityPlayer player) {
		if(slotId >= 0) {
			Slot slot = field_75151_b.get(slotId);
			if(slot instanceof SlotFalseCopy) {
				if(clickType == ClickType.QUICK_MOVE) {
					slot.func_75215_d(ItemStack.field_190927_a);
				}
				else {
					ItemStack toPut = player.field_71071_by.func_70445_o().func_77946_l();
					ItemStack stack = slot.func_75211_c().func_77946_l();
					switch(mouseButton) {
					case 0: {
						slot.func_75215_d(toPut);
						break;
					}
					case 1: {
						if(stack.func_190926_b()) {
							if(!toPut.func_190926_b()) {
								toPut.func_190920_e(1);
							}
							slot.func_75215_d(toPut);
						}
						else if(stack.func_77969_a(toPut) && ItemStack.areItemStackShareTagsEqual(stack, toPut) && stack.func_190916_E() < stack.func_77976_d()) {
							stack.func_190917_f(1);
							slot.func_75215_d(stack);
						}
						else {
							stack.func_190918_g(1);
							slot.func_75215_d(stack);
						}
						break;
					}
					}
				}
				return player.field_71071_by.func_70445_o();
			}
		}
		return super.func_184996_a(slotId, mouseButton, clickType, player);
	}

	@Override
	public boolean func_75145_c(EntityPlayer player) {
		return inventory.func_70300_a(player);
	}

	@Override
	public void func_75142_b() {
		super.func_75142_b();
		for(int i = 0; i < inventory.func_174890_g(); ++i) {
			int val = inventory.func_174887_a_(i);
			if(!prevSyncValues.containsKey(i) || prevSyncValues.get(i) != val) {
				for(IContainerListener listener : field_75149_d) {
					listener.func_71112_a(this, i, val);
				}
				prevSyncValues.put(i, val);
			}
		}
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void func_75137_b(int id, int data) {
		inventory.func_174885_b(id, data);
	}
}
