package thelm.packagedauto.crafting;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.item.ItemDistributorMarker;

public class RecipeDistributorMarkerCloning extends IForgeRegistryEntry.Impl<IRecipe> implements IRecipe {

	public static final RecipeDistributorMarkerCloning INSTANCE = new RecipeDistributorMarkerCloning();

	protected RecipeDistributorMarkerCloning() {
		setRegistryName("packagedauto:distributor_marker_cloning");
	}

	@Override
	public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
		DirectionalGlobalPos template = null;
		int copyCount = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ItemDistributorMarker.INSTANCE) {
					DirectionalGlobalPos globalPos = ItemDistributorMarker.INSTANCE.getDirectionalGlobalPos(stack);
					if(globalPos != null) {
						if(template != null) {
							return false;
						}
						template = globalPos;
					}
					else {
						++copyCount;
					}
				}
				else {
					return false;
				}
			}
		}
		return template != null && copyCount > 0;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv) {
		DirectionalGlobalPos template = null;
		int copyCount = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ItemDistributorMarker.INSTANCE) {
					DirectionalGlobalPos globalPos = ItemDistributorMarker.INSTANCE.getDirectionalGlobalPos(stack);
					if(globalPos != null) {
						if(template != null) {
							return ItemStack.field_190927_a;
						}
						template = globalPos;
					}
					else {
						++copyCount;
					}
				}
				else {
					return ItemStack.field_190927_a;
				}
			}
		}
		if(template != null && copyCount > 0) {
			ItemStack result = new ItemStack(ItemDistributorMarker.INSTANCE, copyCount+1);
			ItemDistributorMarker.INSTANCE.setDirectionalGlobalPos(result, template);
			return result;
		}
		else {
			return ItemStack.field_190927_a;
		}
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return width*height >= 2;
	}

	@Override
	public ItemStack func_77571_b() {
		return ItemStack.field_190927_a;
	}

	@Override
	public boolean func_192399_d() {
		return true;
	}
}
