package thelm.packagedauto.crafting;

import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedauto.api.IRecipeList;
import thelm.packagedauto.item.ItemRecipeHolder;

public class RecipeRecipeHolderCloning extends IForgeRegistryEntry.Impl<IRecipe> implements IRecipe {

	public static final RecipeRecipeHolderCloning INSTANCE = new RecipeRecipeHolderCloning();

	protected RecipeRecipeHolderCloning() {
		setRegistryName("packagedauto:recipe_holder_cloning");
	}

	@Override
	public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
		IRecipeList template = null;
		int copyCount = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ItemRecipeHolder.INSTANCE) {
					IRecipeList recipeListObj = ItemRecipeHolder.INSTANCE.getRecipeList(stack);
					if(!recipeListObj.getRecipeList().isEmpty()) {
						if(template != null) {
							return false;
						}
						template = recipeListObj;
					}
					else {
						++copyCount;
					}
				}
				else {
					return false;
				}
			}
		}
		return template != null && copyCount > 0;
	}

	@Override
	public ItemStack func_77572_b(InventoryCrafting inv) {
		IRecipeList template = null;
		int copyCount = 0;
		for(int i = 0; i < inv.func_70302_i_(); ++i) {
			ItemStack stack = inv.func_70301_a(i);
			if(!stack.func_190926_b()) {
				if(stack.func_77973_b() == ItemRecipeHolder.INSTANCE) {
					IRecipeList recipeListObj = ItemRecipeHolder.INSTANCE.getRecipeList(stack);
					if(!recipeListObj.getRecipeList().isEmpty()) {
						if(template != null) {
							return ItemStack.field_190927_a;
						}
						template = recipeListObj;
					}
					else {
						++copyCount;
					}
				}
				else {
					return ItemStack.field_190927_a;
				}
			}
		}
		if(template != null && copyCount > 0) {
			ItemStack result = new ItemStack(ItemRecipeHolder.INSTANCE, copyCount+1);
			ItemRecipeHolder.INSTANCE.setRecipeList(result, template);
			return result;
		}
		else {
			return ItemStack.field_190927_a;
		}
	}

	@Override
	public boolean func_194133_a(int width, int height) {
		return width*height >= 2;
	}

	@Override
	public ItemStack func_77571_b() {
		return ItemStack.field_190927_a;
	}

	@Override
	public boolean func_192399_d() {
		return true;
	}
}
