package thelm.packagedauto.inventory;

import com.google.common.primitives.Ints;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.api.IDistributorMarkerItem;
import thelm.packagedauto.tile.TileDistributor;

public class InventoryDistributor extends InventoryTileBase {

	public final TileDistributor tile;

	public InventoryDistributor(TileDistributor tile) {
		super(tile, 81);
		this.tile = tile;
	}

	@Override
	public void func_70299_a(int index, ItemStack stack) {
		super.func_70299_a(index, stack);
		loadMarker(index);
	}

	@Override
	public ItemStack func_70298_a(int index, int count) {
		ItemStack stack = super.func_70298_a(index, count);
		loadMarker(index);
		return stack;
	}

	@Override
	public int func_70297_j_() {
		return 1;
	}

	@Override
	public boolean func_94041_b(int slot, ItemStack stack) {
		return stack.func_77973_b() instanceof IDistributorMarkerItem && ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack) != null;
	}

	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		for(int i = 0; i < 81; ++i) {
			loadMarker(i);
		}
	}

	@Override
	public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
		return false;
	}

	@Override
	public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
		return false;
	}

	public void loadMarker(int slot) {
		ItemStack stack = func_70301_a(slot);
		if(stack.func_77973_b() instanceof IDistributorMarkerItem) {
			DirectionalGlobalPos pos = ((IDistributorMarkerItem)stack.func_77973_b()).getDirectionalGlobalPos(stack);
			if(pos == null) {
				tile.positions.remove(slot);
			}
			else if(tile.func_145831_w() != null && tile.func_145831_w().field_73011_w.getDimension() != pos.dimension()) {
				tile.positions.remove(slot);
			}
			else {
				Vec3i dirVec = pos.blockPos().func_177973_b(tile.func_174877_v());
				int dist = Ints.max(Math.abs(dirVec.func_177958_n()), Math.abs(dirVec.func_177956_o()), Math.abs(dirVec.func_177952_p()));
				if(dist <= TileDistributor.range) {
					tile.positions.put(slot, pos);
				}
			}
		}
		else {
			tile.positions.remove(slot);
		}
	}
}
