package thelm.packagedauto.inventory;

import java.util.stream.IntStream;

import com.google.common.collect.Streams;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.energy.CapabilityEnergy;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TilePackagerExtension;

public class InventoryPackager extends InventoryTileBase {

	public final TilePackager tile;

	public InventoryPackager(TilePackager tile) {
		super(tile, 12);
		this.tile = tile;
		slots = IntStream.rangeClosed(0, 9).toArray();
	}

	@Override
	public void func_70299_a(int index, ItemStack stack) {
		if(index < 9 && !tile.func_145831_w().field_72995_K) {
			if(tile.isWorking && !func_70301_a(index).func_190926_b()) {
				if(stack.func_190926_b() || !stack.func_77969_a(func_70301_a(index)) || !tile.isInputValid()) {
					tile.endProcess();
				}
			}
		}
		super.func_70299_a(index, stack);
		if(index == 10) {
			updatePatternList();
		}
	}

	@Override
	public ItemStack func_70298_a(int index, int count) {
		ItemStack stack = super.func_70298_a(index, count);
		if(index < 9 && !tile.func_145831_w().field_72995_K) {
			if(tile.isWorking && !func_70301_a(index).func_190926_b() && !tile.isInputValid()) {
				tile.endProcess();
			}
		}
		if(index == 10) {
			updatePatternList();
		}
		return stack;
	}

	@Override
	public boolean func_94041_b(int index, ItemStack stack) {
		switch(index) {
		case 9: return false;
		case 10: return stack.func_77973_b() instanceof IRecipeListItem || stack.func_77973_b() instanceof IPackageItem;
		case 11: return stack.hasCapability(CapabilityEnergy.ENERGY, null);
		default: return tile.isWorking ? !func_70301_a(index).func_190926_b() : true;
		}
	}

	@Override
	public int func_174887_a_(int id) {
		switch(id) {
		case 0: return tile.remainingProgress;
		case 1: return tile.isWorking ? 1 : 0;
		case 2: return tile.mode.ordinal();
		case 3: return tile.getEnergyStorage().getEnergyStored();
		default: return 0;
		}
	}

	@Override
	public void func_174885_b(int id, int value) {
		switch(id) {
		case 0:
			tile.remainingProgress = value;
			break;
		case 1:
			tile.isWorking = value != 0;
			break;
		case 2:
			tile.mode = TilePackager.Mode.values()[value];
			break;
		case 3:
			tile.getEnergyStorage().setEnergyStored(value);
			break;
		}
	}

	@Override
	public int func_174890_g() {
		return 4;
	}

	@Override
	public void readFromNBT(NBTTagCompound nbt) {
		super.readFromNBT(nbt);
		updatePatternList();
	}

	@Override
	public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
		return index < 9;
	}

	@Override
	public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
		return index == 9 || direction == EnumFacing.UP && index != 10 && index != 11;
	}

	public void updatePatternList() {
		tile.patternList.clear();
		ItemStack listStack = func_70301_a(10);
		if(listStack.func_77973_b() instanceof IRecipeListItem) {
			((IRecipeListItem)listStack.func_77973_b()).getRecipeList(listStack).getRecipeList().stream().
			filter(IRecipeInfo::isValid).forEach(recipe->{
				recipe.getPatterns().forEach(tile.patternList::add);
				recipe.getExtraPatterns().forEach(tile.patternList::add);
			});
		}
		else if(listStack.func_77973_b() instanceof IPackageItem) {
			IPackageItem packageItem = (IPackageItem)listStack.func_77973_b();
			IRecipeInfo recipe = packageItem.getRecipeInfo(listStack);
			int index = packageItem.getIndex(listStack);
			if(recipe != null && recipe.isValid() && recipe.validPatternIndex(index)) {
				tile.patternList.add(recipe.getPatterns().get(index));
			}
		}
		switch(tile.mode) {
		case EXACT:
			tile.disjoint = false;
			break;
		case DISJOINT:
			tile.disjoint = MiscUtil.arePatternsDisjoint(tile.patternList);
			break;
		case FIRST:
			tile.disjoint = true;
			break;
		}
		if(tile.func_145831_w() != null && !tile.func_145831_w().field_72995_K && tile.hostHelper != null) {
			tile.hostHelper.postPatternChange();
		}
		if(tile.func_145831_w() != null) {
			Streams.stream(BlockPos.func_177980_a(tile.func_174877_v().func_177982_a(-1, -1, -1), tile.func_174877_v().func_177982_a(1, 1, 1))).
			map(tile.func_145831_w()::func_175625_s).filter(t->t instanceof TilePackagerExtension).
			map(t->(TilePackagerExtension)t).forEach(t->t.updatePatternList());
		}
	}
}
