package thelm.packagedauto.inventory;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.stream.IntStream;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.tile.TileBase;

public class InventoryTileBase implements ISidedInventory {

	public final NonNullList<ItemStack> stacks;
	public final TileBase tile;
	public int[] slots;
	protected Map<EnumFacing, IItemHandlerModifiable> wrapperMap = new IdentityHashMap<>(7);

	public InventoryTileBase(TileBase tile, int size) {
		this.tile = tile;
		stacks = NonNullList.func_191197_a(size, ItemStack.field_190927_a);
		slots = IntStream.range(0, size).toArray();
	}

	@Override
	public int func_70302_i_() {
		return stacks.size();
	}

	@Override
	public boolean func_191420_l() {
		for(ItemStack stack : stacks) {
			if(!stack.func_190926_b()) {
				return false;
			}
		}
		return true;
	}

	@Override
	public ItemStack func_70301_a(int index) {
		return index >= 0 && index < stacks.size() ? stacks.get(index) : ItemStack.field_190927_a;
	}

	@Override
	public ItemStack func_70298_a(int index, int count) {
		ItemStack stack = ItemStackHelper.func_188382_a(stacks, index, count);
		func_70296_d();
		return stack;
	}

	@Override
	public ItemStack func_70304_b(int index) {
		ItemStack stack = ItemStackHelper.func_188383_a(stacks, index);
		func_70296_d();
		return stack;
	}

	@Override
	public void func_70299_a(int index, ItemStack stack) {
		if(index >= 0 && index < stacks.size()) {
			stacks.set(index, stack);
		}
		func_70296_d();
	}

	@Override
	public int func_70297_j_() {
		return Items.field_190931_a.func_77639_j();
	}

	@Override
	public void func_70296_d() {
		if(tile != null) {
			tile.func_70296_d();
		}
	}

	public void syncTile(boolean rerender) {
		if(tile != null) {
			tile.syncTile(rerender);
		}
	}

	@Override
	public boolean func_70300_a(EntityPlayer player) {
		if(tile != null) {
			BlockPos pos = tile.func_174877_v();
			return tile.func_145831_w().func_175625_s(pos) == tile && pos.func_177957_d(player.field_70165_t, player.field_70163_u, player.field_70161_v) <= 64;
		}
		return true;
	}

	@Override
	public void func_174889_b(EntityPlayer player) {}

	@Override
	public void func_174886_c(EntityPlayer player) {}

	@Override
	public boolean func_94041_b(int index, ItemStack stack) {
		return true;
	}

	@Override
	public int func_174887_a_(int id) {
		return 0;
	}

	@Override
	public void func_174885_b(int id, int value) {}

	@Override
	public int func_174890_g() {
		return 0;
	}

	@Override
	public void func_174888_l() {
		stacks.clear();
	}

	@Override
	public String func_70005_c_() {
		return tile != null ? tile.func_70005_c_() : "[null]";
	}

	@Override
	public boolean func_145818_k_() {
		return tile != null && tile.func_145818_k_();
	}

	@Override
	public ITextComponent func_145748_c_() {
		return tile != null ? tile.func_145748_c_() : new TextComponentString("[null]");
	}

	@Override
	public int[] func_180463_a(EnumFacing side) {
		return slots;
	}

	@Override
	public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
		return true;
	}

	@Override
	public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
		return true;
	}

	public void readFromNBT(NBTTagCompound nbt) {
		stacks.clear();
		MiscUtil.loadAllItems(nbt.func_150295_c("Items", 10), stacks, "Slot");
	}

	public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
		nbt.func_74782_a("Items", MiscUtil.saveAllItems(new NBTTagList(), stacks, "Slot"));
		return nbt;
	}

	public IItemHandlerModifiable getWrapperForDirection(EnumFacing direction) {
		return wrapperMap.computeIfAbsent(direction, f->new SidedInvWrapper(this, f));
	}
}
