package thelm.packagedauto.item;

import java.util.List;

import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.api.PatternType;
import thelm.packagedauto.client.IModelRegister;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternHelper;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternHelper;

@Optional.InterfaceList({
	@Optional.Interface(iface="appeng.api.implementations.ICraftingPatternItem", modid="appliedenergistics2"),
})
public class ItemPackage extends Item implements IPackageItem, IModelRegister, ICraftingPatternItem {

	public static final ItemPackage INSTANCE = new ItemPackage();
	public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:package#inventory");

	protected ItemPackage() {
		func_77655_b("packagedauto.package");
		setRegistryName("packagedauto:package");
		func_77637_a(null);
	}

	public static ItemStack makePackage(IRecipeInfo recipeInfo, int index) {
		ItemStack stack = new ItemStack(INSTANCE);
		NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), recipeInfo);
		tag.func_74774_a("Index", (byte)index);
		stack.func_77982_d(tag);
		return stack;
	}

	@Override
	public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
		if(!worldIn.field_72995_K && playerIn.func_70093_af()) {
			ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
			ItemStack stack1 = stack.func_77979_a(1);
			IRecipeInfo recipe = getRecipeInfo(stack1);
			int index = getIndex(stack1);
			if(recipe != null && recipe.validPatternIndex(index)) {
				List<ItemStack> inputs = recipe.getPatterns().get(index).getInputs();
				for(int i = 0; i < inputs.size(); ++i) {
					ItemStack input = inputs.get(i).func_77946_l();
					if(!playerIn.field_71071_by.func_70441_a(input)) {
						EntityItem item = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, input);
						item.func_145799_b(playerIn.func_70005_c_());
						worldIn.func_72838_d(item);
					}
				}
			}
			return new ActionResult<>(EnumActionResult.SUCCESS, stack);
		}
		return super.func_77659_a(worldIn, playerIn, handIn);
	}

	@Override
	public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
		IRecipeInfo recipe = getRecipeInfo(stack);
		int index = getIndex(stack);
		if(recipe != null && recipe.validPatternIndex(index)) {
			tooltip.add(recipe.getRecipeType().getLocalizedName()+": ");
			for(ItemStack is : recipe.getOutputs()) {
				tooltip.add(is.func_190916_E()+" "+is.func_82833_r());
			}
			tooltip.add(I18n.func_74837_a("item.packagedauto.package.index", index));
			tooltip.add(I18n.func_74838_a("item.packagedauto.package.items"));
			List<ItemStack> recipeInputs = recipe.getInputs();
			List<ItemStack> packageItems = recipeInputs.subList(9*index, Math.min(9*index+9, recipeInputs.size()));
			for(ItemStack is : packageItems) {
				tooltip.add(is.func_190916_E()+" "+is.func_82833_r());
			}
		}
		super.func_77624_a(stack, worldIn, tooltip, flagIn);
	}

	@Override
	public IRecipeInfo getRecipeInfo(ItemStack stack) {
		if(stack.func_77942_o()) {
			NBTTagCompound tag = stack.func_77978_p();
			return MiscUtil.readRecipeFromNBT(tag);
		}
		return null;
	}

	@Override
	public int getIndex(ItemStack stack) {
		if(stack.func_77942_o()) {
			return stack.func_77978_p().func_74771_c("Index");
		}
		return -1;
	}

	@Override
	public PatternType getPatternType(ItemStack stack) {
		if(stack.func_77942_o()) {
			return PatternType.fromName(stack.func_77978_p().func_74779_i("PatternType"));
		}
		return null;
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public ICraftingPatternDetails getPatternForItem(ItemStack stack, World world) {
		PatternType patternType = getPatternType(stack);
		if(patternType != null) {
			switch(getPatternType(stack)) {
			case PACKAGE: {
				IRecipeInfo recipe = getRecipeInfo(stack);
				int index = getIndex(stack);
				if(recipe != null && recipe.isValid() && recipe.validPatternIndex(index)) {
					return new PackageCraftingPatternHelper(recipe.getPatterns().get(index));
				}
				break;
			}
			case RECIPE: {
				IRecipeInfo recipe = getRecipeInfo(stack);
				if(recipe != null && recipe.isValid()) {
					return new RecipeCraftingPatternHelper(recipe);
				}
				break;
			}
			}
		}
		return null;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public void registerModels() {
		ModelLoader.setCustomModelResourceLocation(this, 0, MODEL_LOCATION);
	}
}
