package thelm.packagedauto.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.network.ISelfHandleMessage;
import thelm.packagedauto.slot.SlotFalseCopy;

public class PacketSetItemStack implements ISelfHandleMessage<IMessage> {

	private short containerSlot;
	private ItemStack stack;

	public PacketSetItemStack() {}

	public PacketSetItemStack(short containerSlot, ItemStack stack) {
		this.containerSlot = containerSlot;
		this.stack = stack;
	}

	@Override
	public void toBytes(ByteBuf buf) {
		buf.writeShort(containerSlot);
		MiscUtil.writeItemWithLargeCount(buf, stack);
	}

	@Override
	public void fromBytes(ByteBuf buf) {
		containerSlot = buf.readShort();
		stack = MiscUtil.readItemWithLargeCount(buf);
	}

	@Override
	public IMessage onMessage(MessageContext ctx) {
		EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
		WorldServer world = player.func_71121_q();
		world.func_152344_a(()->{
			Container container = player.field_71070_bA;
			if(container != null) {
				if(containerSlot >= 0 && containerSlot < container.field_75151_b.size()) {
					Slot slot = container.func_75139_a(containerSlot);
					if(slot instanceof SlotFalseCopy) {
						IInventory inventory = ((SlotFalseCopy)slot).inventory;
						inventory.func_70299_a(slot.getSlotIndex(), stack);
					}
				}
			}
		});
		return null;
	}
}
