package thelm.packagedauto.tile;

import java.util.List;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.gui.GuiCrafter;
import thelm.packagedauto.container.ContainerCrafter;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.networking.HostHelperTileCrafter;
import thelm.packagedauto.inventory.InventoryCrafter;
import thelm.packagedauto.recipe.IRecipeInfoCrafting;

@Optional.InterfaceList({
	@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"),
	@Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2"),
})
public class TileCrafter extends TileBase implements ITickable, IPackageCraftingMachine, IGridHost, IActionHost {

	public static boolean enabled = false;

	public static int energyCapacity = 5000;
	public static int energyReq = 500;
	public static int energyUsage = 100;
	public static int refreshInterval = 4;
	public static boolean drawMEEnergy = true;

	public boolean isWorking = false;
	public int remainingProgress = 0;
	public IRecipeInfoCrafting currentRecipe;

	public TileCrafter() {
		setInventory(new InventoryCrafter(this));
		setEnergyStorage(new EnergyStorage(this, energyCapacity));
		if(Loader.isModLoaded("appliedenergistics2")) {
			hostHelper = new HostHelperTileCrafter(this);
		}
	}

	@Override
	protected String getLocalizedName() {
		return I18n.func_74838_a("tile.packagedauto.crafter.name");
	}

	@Override
	public void func_73660_a() {
		if(!field_145850_b.field_72995_K) {
			if(isWorking) {
				tickProcess();
				if(remainingProgress <= 0) {
					finishProcess();
					if(hostHelper != null && hostHelper.isActive()) {
						hostHelper.ejectItem();
					}
					else {
						ejectItems();
					}
				}
			}
			chargeEnergy();
			if(field_145850_b.func_82737_E() % refreshInterval == 0) {
				if(hostHelper != null && hostHelper.isActive()) {
					hostHelper.ejectItem();
					if(drawMEEnergy) {
						hostHelper.chargeEnergy();
					}
				}
				else {
					ejectItems();
				}
			}
		}
	}

	@Override
	public boolean acceptPackage(IRecipeInfo recipeInfo, List<ItemStack> stacks, EnumFacing facing) {
		if(!isBusy() && recipeInfo.isValid() && recipeInfo instanceof IRecipeInfoCrafting) {
			IRecipeInfoCrafting recipe = (IRecipeInfoCrafting)recipeInfo;
			ItemStack slotStack = inventory.func_70301_a(9);
			ItemStack outputStack = recipe.getOutput();
			if(slotStack.func_190926_b() || slotStack.func_77969_a(outputStack) && ItemStack.areItemStackShareTagsEqual(slotStack, outputStack) && slotStack.func_190916_E()+outputStack.func_190916_E() <= outputStack.func_77976_d()) {
				currentRecipe = recipe;
				isWorking = true;
				remainingProgress = energyReq;
				for(int i = 0; i < 9; ++i) {
					inventory.func_70299_a(i, recipe.getMatrix().func_70301_a(i).func_77946_l());
				}
				func_70296_d();
				return true;
			}
		}
		return false;
	}

	@Override
	public boolean isBusy() {
		return isWorking || !inventory.stacks.subList(0, 9).stream().allMatch(ItemStack::func_190926_b);
	}

	protected void tickProcess() {
		int energy = energyStorage.extractEnergy(Math.min(energyUsage, remainingProgress), false);
		remainingProgress -= energy;
	}

	protected void finishProcess() {
		if(currentRecipe == null) {
			endProcess();
			return;
		}
		if(inventory.func_70301_a(9).func_190926_b()) {
			inventory.func_70299_a(9, currentRecipe.getOutput());
		}
		else {
			inventory.func_70301_a(9).func_190917_f(currentRecipe.getOutput().func_190916_E());
		}
		List<ItemStack> remainingItems = currentRecipe.getRemainingItems();
		for(int i = 0; i < 9; ++i) {
			inventory.func_70299_a(i, remainingItems.get(i));
		}
		endProcess();
	}

	public void endProcess() {
		remainingProgress = 0;
		isWorking = false;
		currentRecipe = null;
		func_70296_d();
	}

	protected void ejectItems() {
		int endIndex = isWorking ? 9 : 0;
		for(EnumFacing facing : EnumFacing.field_82609_l) {
			TileEntity tile = field_145850_b.func_175625_s(field_174879_c.func_177972_a(facing));
			if(tile != null && !(tile instanceof TileUnpackager) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
				IItemHandler itemHandler = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
				for(int i = 9; i >= endIndex; --i) {
					ItemStack stack = inventory.func_70301_a(i);
					if(stack.func_190926_b()) {
						continue;
					}
					ItemStack stackRem = ItemHandlerHelper.insertItem(itemHandler, stack, false);
					inventory.func_70299_a(i, stackRem);
				}
			}
		}
	}

	protected void chargeEnergy() {
		ItemStack energyStack = inventory.func_70301_a(10);
		if(energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
			int energyRequest = Math.min(energyStorage.getMaxReceive(), energyStorage.getMaxEnergyStored() - energyStorage.getEnergyStored());
			energyStorage.receiveEnergy(energyStack.getCapability(CapabilityEnergy.ENERGY, null).extractEnergy(energyRequest, false), false);
			if(energyStack.func_190916_E() <= 0) {
				inventory.func_70299_a(10, ItemStack.field_190927_a);
			}
		}
	}

	@Override
	public int getComparatorSignal() {
		if(isWorking) {
			return 1;
		}
		if(!inventory.stacks.subList(0, 10).stream().allMatch(ItemStack::func_190926_b)) {
			return 15;
		}
		return 0;
	}

	public HostHelperTileCrafter hostHelper;

	@Override
	public void func_145843_s() {
		super.func_145843_s();
		if(hostHelper != null) {
			hostHelper.invalidate();
		}
	}

	@Override
	public void onChunkUnload() {
		super.onChunkUnload();
		if(hostHelper != null) {
			hostHelper.invalidate();
		}
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public IGridNode getGridNode(AEPartLocation dir) {
		return getActionableNode();
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public AECableType getCableConnectionType(AEPartLocation dir) {
		return AECableType.SMART;
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public void securityBreak() {
		field_145850_b.func_175655_b(field_174879_c, true);
	}

	@Optional.Method(modid="appliedenergistics2")
	@Override
	public IGridNode getActionableNode() {
		return hostHelper.getNode();
	}

	@Override
	public void func_145839_a(NBTTagCompound nbt) {
		if(hostHelper != null) {
			hostHelper.readFromNBT(nbt);
		}
		super.func_145839_a(nbt);
		isWorking = nbt.func_74767_n("Working");
		remainingProgress = nbt.func_74762_e("Progress");
		currentRecipe = null;
		if(nbt.func_74764_b("Recipe")) {
			NBTTagCompound tag = nbt.func_74775_l("Recipe");
			IRecipeInfo recipe = MiscUtil.readRecipeFromNBT(tag);
			if(recipe instanceof IRecipeInfoCrafting) {
				currentRecipe = (IRecipeInfoCrafting)recipe;
			}
		}
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
		super.func_189515_b(nbt);
		nbt.func_74757_a("Working", isWorking);
		nbt.func_74768_a("Progress", remainingProgress);
		if(currentRecipe != null) {
			NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), currentRecipe);
			nbt.func_74782_a("Recipe", tag);
		}
		if(hostHelper != null) {
			hostHelper.writeToNBT(nbt);
		}
		return nbt;
	}

	public int getScaledEnergy(int scale) {
		if(energyStorage.getMaxEnergyStored() <= 0) {
			return 0;
		}
		return scale * energyStorage.getEnergyStored() / energyStorage.getMaxEnergyStored();
	}

	public int getScaledProgress(int scale) {
		if(remainingProgress <= 0) {
			return 0;
		}
		return scale * (energyReq-remainingProgress) / energyReq;
	}

	@SideOnly(Side.CLIENT)
	@Override
	public GuiContainer getClientGuiElement(EntityPlayer player, Object... args) {
		return new GuiCrafter(new ContainerCrafter(player.field_71071_by, this));
	}

	@Override
	public Container getServerGuiElement(EntityPlayer player, Object... args) {
		return new ContainerCrafter(player.field_71071_by, this);
	}
}
