/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.BaseItemHandler;

public abstract class BaseBlockEntity
extends BlockEntity
implements Nameable,
MenuProvider {
    protected BaseItemHandler<?> itemHandler = new BaseItemHandler<BaseBlockEntity>(this, 0);
    protected EnergyStorage energyStorage = new EnergyStorage(this, 0);
    public Component customName = null;
    protected UUID ownerUUID = null;

    public BaseBlockEntity(BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(blockEntityType, pos, state);
    }

    public BaseItemHandler<?> getItemHandler() {
        return this.itemHandler;
    }

    public IItemHandler getItemHandler(Direction direction) {
        return this.itemHandler.getWrapperForDirection(direction);
    }

    public void setItemHandler(BaseItemHandler<?> itemHandler) {
        this.itemHandler = itemHandler;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public EnergyStorage getEnergyStorage(Direction direction) {
        return this.energyStorage;
    }

    public void setEnergyStorage(EnergyStorage energyStorage) {
        this.energyStorage = energyStorage;
    }

    public void setOwner(Player owner) {
        this.ownerUUID = owner.getUUID();
    }

    public Component getName() {
        return this.customName != null ? this.customName : this.getDefaultName();
    }

    public Component getDisplayName() {
        return this.getName();
    }

    public Component getCustomName() {
        return this.customName;
    }

    protected abstract Component getDefaultName();

    public void tick() {
    }

    public int getComparatorSignal() {
        return ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)this.itemHandler.getWrapperForDirection(null));
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        this.customName = (Component)componentInput.get(DataComponents.CUSTOM_NAME);
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CUSTOM_NAME, (Object)this.customName);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.ownerUUID = null;
        if (nbt.hasUUID("owner_uuid")) {
            this.ownerUUID = nbt.getUUID("owner_uuid");
        }
        this.loadSync(nbt, registries);
        this.itemHandler.load(nbt, registries);
        this.energyStorage.read(nbt);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.ownerUUID != null) {
            nbt.putUUID("owner_uuid", this.ownerUUID);
        }
        this.saveSync(nbt, registries);
        this.itemHandler.save(nbt, registries);
        this.energyStorage.save(nbt);
    }

    public void loadSync(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("name")) {
            this.customName = ComponentSerialization.CODEC.parse((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)nbt.get("name")).result().orElse(null);
        }
    }

    public CompoundTag saveSync(CompoundTag nbt, HolderLookup.Provider registries) {
        if (this.customName != null) {
            nbt.put("name", (Tag)ComponentSerialization.CODEC.encodeStart((DynamicOps)registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)this.customName).result().get());
        }
        return nbt;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        if (pkt.getTag() != null) {
            this.loadSync(pkt.getTag(), registries);
        }
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadSync(tag, registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag nbt = super.getUpdateTag(registries);
        this.saveSync(nbt, registries);
        return nbt;
    }

    public void sync(boolean rerender) {
        if (this.level != null && this.level.isLoaded(this.worldPosition)) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 2 + (rerender ? 4 : 0));
        }
    }

    public static <T extends BlockEntity> void tick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        if (blockEntity instanceof BaseBlockEntity) {
            BaseBlockEntity baseBlockEntity = (BaseBlockEntity)blockEntity;
            baseBlockEntity.tick();
        }
    }
}

