/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.block.entity.PackagedAutoBlockEntities;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.FluidPackageFillerItemHandler;
import thelm.packagedauto.menu.FluidPackageFillerMenu;
import thelm.packagedauto.util.MiscHelper;

public class FluidPackageFillerBlockEntity
extends BaseBlockEntity
implements ISettingsCloneable {
    public static int energyCapacity = 5000;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static int refreshInterval = 4;
    public boolean firstTick = true;
    public boolean isWorking = false;
    public FluidStack currentFluid = FluidStack.EMPTY;
    public int requiredAmount = 100;
    public int amount = 0;
    public int remainingProgress = 0;
    public boolean powered = false;
    public boolean activated = false;

    public FluidPackageFillerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedAutoBlockEntities.FLUID_PACKAGE_FILLER.get(), pos, state);
        this.setItemHandler(new FluidPackageFillerItemHandler(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
    }

    @Override
    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedauto.fluid_package_filler");
    }

    @Override
    public String getConfigTypeName() {
        return "block.packagedauto.fluid_package_filler";
    }

    @Override
    public void tick() {
        if (this.firstTick) {
            this.firstTick = false;
            this.updatePowered();
        }
        if (!this.level.isClientSide) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0 && this.isTemplateValid()) {
                    this.finishProcess();
                    if (!this.itemHandler.getStackInSlot(1).isEmpty()) {
                        this.ejectItem();
                    }
                    if (!this.canStart()) {
                        this.endProcess();
                    } else {
                        this.startProcess();
                    }
                }
            } else if (this.activated && this.canStart()) {
                this.startProcess();
                this.tickProcess();
                this.activated = false;
                this.isWorking = true;
            }
            this.chargeEnergy();
            if (this.level.getGameTime() % (long)refreshInterval == 0L && !this.itemHandler.getStackInSlot(1).isEmpty()) {
                this.ejectItem();
            }
        }
    }

    public boolean isTemplateValid() {
        if (this.currentFluid.isEmpty()) {
            this.getFluid();
        }
        return !this.currentFluid.isEmpty();
    }

    public boolean canStart() {
        this.getFluid();
        if (this.currentFluid.isEmpty()) {
            return false;
        }
        if (!this.isTemplateValid()) {
            return false;
        }
        ItemStack slotStack = this.itemHandler.getStackInSlot(1);
        ItemStack outputStack = MiscHelper.INSTANCE.tryMakeVolumePackage(this.currentFluid);
        return slotStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.getCount() + 1 <= outputStack.getMaxStackSize();
    }

    protected boolean canFinish() {
        return this.remainingProgress <= 0 && this.isTemplateValid();
    }

    protected void getFluid() {
        this.currentFluid = FluidStack.EMPTY;
        ItemStack template = this.itemHandler.getStackInSlot(0);
        if (template.isEmpty()) {
            return;
        }
        FluidUtil.getFluidContained((ItemStack)template).filter(s -> !s.isEmpty()).ifPresent(s -> {
            this.currentFluid = s.copy();
            this.currentFluid.setAmount(this.requiredAmount);
        });
    }

    protected void tickProcess() {
        if (this.amount < this.requiredAmount) {
            for (Direction direction : Direction.values()) {
                IFluidHandler fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.worldPosition.relative(direction), (Object)direction.getOpposite());
                if (fluidHandler == null) continue;
                FluidStack toDrain = this.currentFluid.copy();
                toDrain.setAmount(this.requiredAmount - this.amount);
                this.amount += fluidHandler.drain(toDrain, IFluidHandler.FluidAction.EXECUTE).getAmount();
            }
        }
        if (this.amount >= this.requiredAmount) {
            int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
            this.remainingProgress -= energy;
        }
    }

    protected void finishProcess() {
        if (this.currentFluid.isEmpty()) {
            this.getFluid();
        }
        if (this.currentFluid.isEmpty()) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(1).isEmpty()) {
            this.itemHandler.setStackInSlot(1, MiscHelper.INSTANCE.tryMakeVolumePackage(this.currentFluid));
        } else if (this.itemHandler.getStackInSlot(1).has(PackagedAutoDataComponents.VOLUME_PACKAGE_STACK)) {
            this.itemHandler.getStackInSlot(1).grow(1);
        }
        this.endProcess();
    }

    public void startProcess() {
        this.remainingProgress = energyReq;
        this.amount = 0;
        this.sync(false);
        this.setChanged();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.amount = 0;
        this.isWorking = false;
        this.setChanged();
    }

    protected void ejectItem() {
        for (Direction direction : Direction.values()) {
            ItemStack stack;
            BlockPos offsetPos = this.worldPosition.relative(direction);
            Block block = this.level.getBlockState(offsetPos).getBlock();
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
            IFluidHandler fluidHandler = (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
            if (block == PackagedAutoBlocks.UNPACKAGER.get() || itemHandler == null || fluidHandler != null || (stack = this.itemHandler.getStackInSlot(1)).isEmpty()) continue;
            ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
            this.itemHandler.setStackInSlot(1, stackRem);
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(2);
        IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergyStorage != null) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(itemEnergyStorage.extractEnergy(energyRequest, false), false);
            if (energyStack.getCount() <= 0) {
                this.itemHandler.setStackInSlot(2, ItemStack.EMPTY);
            }
        }
    }

    public void updatePowered() {
        if (this.level.getBestNeighborSignal(this.worldPosition) > 0 != this.powered) {
            boolean bl = this.powered = !this.powered;
            if (this.powered && !this.isWorking) {
                this.activated = true;
            }
            this.sync(false);
            this.setChanged();
        }
    }

    @Override
    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStackInSlot(1).isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Override
    public ISettingsCloneable.Result loadConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        this.requiredAmount = nbt.getInt("amount_req");
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(CompoundTag nbt, HolderLookup.Provider registries, Player player) {
        nbt.putInt("amount_req", this.requiredAmount);
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.isWorking = nbt.getBoolean("working");
        this.amount = nbt.getInt("amount");
        this.remainingProgress = nbt.getInt("progress");
        this.powered = nbt.getBoolean("powered");
    }

    @Override
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("working", this.isWorking);
        nbt.putInt("amount", this.amount);
        nbt.putInt("progress", this.remainingProgress);
        nbt.putBoolean("powered", this.powered);
    }

    @Override
    public void loadSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadSync(nbt, registries);
        this.currentFluid = FluidStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("fluid"));
        this.requiredAmount = nbt.getInt("amount_req");
    }

    @Override
    public CompoundTag saveSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveSync(nbt, registries);
        nbt.put("fluid", this.currentFluid.saveOptional(registries));
        nbt.putInt("amount_req", this.requiredAmount);
        return nbt;
    }

    public void setChanged() {
        if (this.isWorking && !this.isTemplateValid()) {
            this.endProcess();
        }
        super.setChanged();
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new FluidPackageFillerMenu(windowId, inventory, this);
    }
}

