/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.emi;

import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import thelm.packagedauto.api.IVolumeType;
import thelm.packagedauto.client.screen.EncoderScreen;
import thelm.packagedauto.integration.emi.PackagedAutoEMIPlugin;
import thelm.packagedauto.menu.EncoderMenu;
import thelm.packagedauto.packet.SetItemStackPacket;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.util.ApiImpl;
import thelm.packagedauto.util.MiscHelper;

public class EncoderDragDropHandler
implements EmiDragDropHandler<EncoderScreen> {
    public boolean dropStack(EncoderScreen gui, EmiIngredient ingredient, int x, int y) {
        ItemStack stack = EncoderDragDropHandler.wrapStack(ingredient);
        if (stack.isEmpty()) {
            return false;
        }
        for (SlotTarget target : this.getTargets(gui, ingredient)) {
            if (!target.getBounds().contains(x, y)) continue;
            target.accept(ingredient);
            return true;
        }
        return false;
    }

    public void render(EncoderScreen gui, EmiIngredient ingredient, GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        ItemStack stack = EncoderDragDropHandler.wrapStack(ingredient);
        if (stack.isEmpty()) {
            return;
        }
        for (SlotTarget target : this.getTargets(gui, ingredient)) {
            Bounds bounds = target.getBounds();
            graphics.fill(bounds.left(), bounds.top(), bounds.right(), bounds.bottom(), -2010989773);
        }
    }

    public List<SlotTarget> getTargets(EncoderScreen gui, EmiIngredient ingredient) {
        ItemStack stack = EncoderDragDropHandler.wrapStack(ingredient);
        if (!stack.isEmpty()) {
            return ((EncoderMenu)gui.menu).slots.stream().filter(s -> s instanceof FalseCopySlot).map(s -> new SlotTarget((Slot)s, EncoderDragDropHandler.getSlotBounds(gui, s))).toList();
        }
        return List.of();
    }

    private static Bounds getSlotBounds(AbstractContainerScreen<?> gui, Slot slot) {
        return new Bounds(gui.getGuiLeft() + slot.x, gui.getGuiTop() + slot.y, 16, 16);
    }

    private static ItemStack wrapStack(EmiIngredient emiIngredient) {
        Optional<?> ingredient = PackagedAutoEMIPlugin.toStack(PackagedAutoEMIPlugin.getTreeEmiStack(emiIngredient));
        if (ingredient.isEmpty()) {
            return ItemStack.EMPTY;
        }
        Object obj = ingredient.get();
        if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            return stack;
        }
        IVolumeType type = ApiImpl.INSTANCE.getVolumeType(ingredient.get().getClass());
        if (type != null) {
            return MiscHelper.INSTANCE.tryMakeVolumePackage(ingredient.get());
        }
        return ItemStack.EMPTY;
    }

    private record SlotTarget(Slot slot, Bounds bounds) {
        public Bounds getBounds() {
            return this.bounds;
        }

        public void accept(EmiIngredient emiIngredient) {
            ItemStack stack = EncoderDragDropHandler.wrapStack(emiIngredient);
            if (!stack.isEmpty()) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SetItemStackPacket(this.slot.index, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }
}

