/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.List;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.world.item.ItemStack;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.component.PackagedAutoDataComponents;
import thelm.packagedauto.integration.jei.category.PackageContentsCategory;
import thelm.packagedauto.integration.jei.category.PackageProcessingCategory;
import thelm.packagedauto.integration.jei.category.PackageRecipeCategory;
import thelm.packagedauto.integration.jei.category.PackagingCategory;
import thelm.packagedauto.util.MiscHelper;

public class PackageManagerPlugin
implements IRecipeManagerPlugin {
    public <V> List<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        Object object = focus.getTypedValue().getIngredient();
        if (object instanceof ItemStack) {
            ItemStack stack = (ItemStack)object;
            if (MiscHelper.INSTANCE.isPackage(stack)) {
                switch (focus.getRole()) {
                    case INPUT: {
                        return List.of(PackageRecipeCategory.TYPE, PackageProcessingCategory.TYPE, PackageContentsCategory.TYPE);
                    }
                    case OUTPUT: {
                        return List.of(PackageRecipeCategory.TYPE, PackagingCategory.TYPE);
                    }
                }
            }
            if (stack.has(PackagedAutoDataComponents.RECIPE_LIST)) {
                switch (focus.getRole()) {
                    case INPUT: {
                        return List.of(PackageRecipeCategory.TYPE, PackageProcessingCategory.TYPE);
                    }
                    case OUTPUT: {
                        return List.of(PackageRecipeCategory.TYPE);
                    }
                }
            }
        }
        return List.of();
    }

    public <T, V> List<T> getRecipes(IRecipeCategory<T> recipeCategory, IFocus<V> focus) {
        Object object = focus.getTypedValue().getIngredient();
        if (object instanceof ItemStack) {
            int index;
            IPackageRecipeInfo recipe;
            ItemStack stack = (ItemStack)object;
            RecipeType type = recipeCategory.getRecipeType();
            if (MiscHelper.INSTANCE.isPackage(stack) && (recipe = (IPackageRecipeInfo)stack.get(PackagedAutoDataComponents.RECIPE)).validPatternIndex(index = ((Integer)stack.get(PackagedAutoDataComponents.PACKAGE_INDEX)).intValue())) {
                if (PackageRecipeCategory.TYPE.equals((Object)type) || PackageProcessingCategory.TYPE.equals((Object)type)) {
                    return List.of(recipe);
                }
                if (PackagingCategory.TYPE.equals((Object)type) || PackageContentsCategory.TYPE.equals((Object)type)) {
                    return List.of(recipe.getPatterns().get(index));
                }
            }
            if (stack.has(PackagedAutoDataComponents.RECIPE_LIST) && (PackageRecipeCategory.TYPE.equals((Object)type) || PackageProcessingCategory.TYPE.equals((Object)type))) {
                return (List)stack.get(PackagedAutoDataComponents.RECIPE_LIST);
            }
        }
        return List.of();
    }

    public <T> List<T> getRecipes(IRecipeCategory<T> recipeCategory) {
        return List.of();
    }
}

