/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import mezz.jei.api.gui.handlers.IGuiContainerHandler;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IUniversalRecipeTransferHandler;
import mezz.jei.api.registration.IAdvancedRegistration;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.fml.ModList;
import thelm.packagedauto.client.screen.EncoderScreen;
import thelm.packagedauto.integration.jei.EncoderGhostIngredientHandler;
import thelm.packagedauto.integration.jei.EncoderGuiHandler;
import thelm.packagedauto.integration.jei.EncoderTransferHandler;
import thelm.packagedauto.integration.jei.FluidPackageManagerPlugin;
import thelm.packagedauto.integration.jei.FluidVolumeGuiHandler;
import thelm.packagedauto.integration.jei.PackageItemSubtypeInterpreter;
import thelm.packagedauto.integration.jei.PackageManagerPlugin;
import thelm.packagedauto.integration.jei.PackageRecipeTransferHandler;
import thelm.packagedauto.integration.jei.VolumePackageItemSubtypeInterpreter;
import thelm.packagedauto.integration.jei.category.FluidPackageContentsCategory;
import thelm.packagedauto.integration.jei.category.FluidPackageFillingCategory;
import thelm.packagedauto.integration.jei.category.PackageContentsCategory;
import thelm.packagedauto.integration.jei.category.PackageProcessingCategory;
import thelm.packagedauto.integration.jei.category.PackageRecipeCategory;
import thelm.packagedauto.integration.jei.category.PackagingCategory;
import thelm.packagedauto.item.PackagedAutoItems;

@JeiPlugin
public class PackagedAutoJEIPlugin
implements IModPlugin {
    public static final ResourceLocation UID = ResourceLocation.parse((String)"packagedauto:jei");
    public static final ResourceLocation BACKGROUND = ResourceLocation.parse((String)"packagedauto:textures/gui/jei.png");
    public static IJeiRuntime jeiRuntime;
    private static List<ResourceLocation> allCategories;

    public ResourceLocation getPluginUid() {
        return UID;
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter((Item)PackagedAutoItems.PACKAGE.get(), (ISubtypeInterpreter)new PackageItemSubtypeInterpreter());
        registration.registerSubtypeInterpreter((Item)PackagedAutoItems.VOLUME_PACKAGE.get(), (ISubtypeInterpreter)new VolumePackageItemSubtypeInterpreter());
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!ModList.get().isLoaded("emi")) {
            IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
            registration.addRecipeCategories(new IRecipeCategory[]{new PackageRecipeCategory(guiHelper), new PackagingCategory(guiHelper), new PackageProcessingCategory(guiHelper), new PackageContentsCategory(guiHelper), new FluidPackageFillingCategory(guiHelper), new FluidPackageContentsCategory(guiHelper)});
        }
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        if (!ModList.get().isLoaded("emi")) {
            IRecipeTransferHandlerHelper transferHelper = registration.getTransferHelper();
            registration.addRecipeTransferHandler((IRecipeTransferHandler)new PackageRecipeTransferHandler(transferHelper), PackageRecipeCategory.TYPE);
            registration.addUniversalRecipeTransferHandler((IUniversalRecipeTransferHandler)new EncoderTransferHandler(transferHelper));
        }
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        if (!ModList.get().isLoaded("emi")) {
            registration.addRecipeCatalyst(PackagedAutoItems.ENCODER.toStack(), new RecipeType[]{PackageRecipeCategory.TYPE});
            registration.addRecipeCatalyst(PackagedAutoItems.PACKAGER.toStack(), new RecipeType[]{PackagingCategory.TYPE});
            registration.addRecipeCatalyst(PackagedAutoItems.PACKAGER_EXTENSION.toStack(), new RecipeType[]{PackagingCategory.TYPE});
            registration.addRecipeCatalyst(PackagedAutoItems.UNPACKAGER.toStack(), new RecipeType[]{PackageProcessingCategory.TYPE});
            registration.addRecipeCatalyst(PackagedAutoItems.FLUID_PACKAGE_FILLER.toStack(), new RecipeType[]{FluidPackageFillingCategory.TYPE});
        }
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!ModList.get().isLoaded("emi")) {
            IIngredientManager ingredientManager = registration.getJeiHelpers().getIngredientManager();
            registration.addGuiContainerHandler(EncoderScreen.class, (IGuiContainerHandler)new EncoderGuiHandler());
            registration.addGenericGuiContainerHandler(AbstractContainerScreen.class, (IGuiContainerHandler)new FluidVolumeGuiHandler(ingredientManager));
            registration.addGhostIngredientHandler(EncoderScreen.class, (IGhostIngredientHandler)new EncoderGhostIngredientHandler());
        }
    }

    public void registerAdvanced(IAdvancedRegistration registration) {
        if (!ModList.get().isLoaded("emi")) {
            registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new PackageManagerPlugin());
            registration.addRecipeManagerPlugin((IRecipeManagerPlugin)new FluidPackageManagerPlugin());
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        PackagedAutoJEIPlugin.jeiRuntime = jeiRuntime;
    }

    public static List<ResourceLocation> getAllRecipeCategories() {
        if (allCategories == null) {
            if (jeiRuntime == null) {
                return List.of();
            }
            allCategories = jeiRuntime.getRecipeManager().createRecipeCategoryLookup().includeHidden().get().map(c -> c.getRecipeType().getUid()).toList();
        }
        return allCategories;
    }

    public static List<ResourceLocation> getRecipeCategoriesForRecipe(Object recipe) {
        if (jeiRuntime == null) {
            return List.of();
        }
        return jeiRuntime.getRecipeManager().createRecipeCategoryLookup().includeHidden().get().map(c -> c.getRecipeType()).filter(t -> t.getRecipeClass().isInstance(recipe)).map(t -> t.getUid()).toList();
    }
}

