/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.packet;

import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.packet.PacketStreamCodecs;

public record DirectionalMarkerPacket(List<DirectionalGlobalPos> positions, int color, int lifetime) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<DirectionalMarkerPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.parse((String)"packagedauto:directional_marker"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DirectionalMarkerPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)DirectionalGlobalPos.STREAM_CODEC.apply(ByteBufCodecs.list()), DirectionalMarkerPacket::positions, PacketStreamCodecs.UNSIGNED_MEDIUM, DirectionalMarkerPacket::color, (StreamCodec)ByteBufCodecs.UNSIGNED_SHORT, DirectionalMarkerPacket::lifetime, DirectionalMarkerPacket::new);

    public CustomPacketPayload.Type<DirectionalMarkerPacket> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> WorldOverlayRenderer.INSTANCE.addDirectionalMarkers(this.positions, this.color, this.lifetime));
    }

    public static void sendDirectionalMarkers(ServerPlayer player, List<DirectionalGlobalPos> positions, int color, int lifetime) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DirectionalMarkerPacket(positions, color, lifetime), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

