package thelm.packagedauto.integration.appeng.tile;

import com.mojang.authlib.GameProfile;

import appeng.api.IAppEngApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.Api;
import appeng.me.helpers.MachineSource;
import appeng.util.Platform;
import net.minecraft.block.BlockState;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.integration.appeng.networking.BaseGridBlock;
import thelm.packagedauto.integration.appeng.recipe.PackageCraftingPatternDetails;
import thelm.packagedauto.tile.PackagerTile;

public class AEPackagerTile extends PackagerTile implements IGridHost, IActionHost, ICraftingProvider {

	public BaseGridBlock<AEPackagerTile> gridBlock;
	public IActionSource source;
	public IGridNode gridNode;

	public AEPackagerTile() {
		super();
		gridBlock = new BaseGridBlock<>(this);
		source = new MachineSource(this);
	}

	@Override
	public void tick() {
		if(firstTick) {
			if(!level.isClientSide) {
				getActionableNode().updateState();
			}
		}
		super.tick();
		if(drawMEEnergy && !level.isClientSide && level.getGameTime() % refreshInterval == 0) {
			chargeMEEnergy();
		}
	}

	@Override
	public void setRemoved() {
		super.setRemoved();
		if(gridNode != null) {
			gridNode.destroy();
		}
	}

	@Override
	public void onChunkUnloaded() {
		super.onChunkUnloaded();
		if(gridNode != null) {
			gridNode.destroy();
		}
	}

	@Override
	public IGridNode getGridNode(AEPartLocation dir) {
		return getActionableNode();
	}

	@Override
	public AECableType getCableConnectionType(AEPartLocation dir) {
		return AECableType.SMART;
	}

	@Override
	public void securityBreak() {
		level.destroyBlock(worldPosition, true);
	}

	@Override
	public IGridNode getActionableNode() {
		if(gridNode == null && !Platform.isClient()) {
			IAppEngApi api = Api.instance();
			gridNode = api.grid().createGridNode(gridBlock);
			if(ownerUUID != null) {
				gridNode.setPlayerID(api.registries().players().getID(new GameProfile(ownerUUID, "[UNKNOWN]")));
			}
		}
		return gridNode;
	}

	@Override
	public boolean pushPattern(ICraftingPatternDetails patternDetails, CraftingInventory table) {
		if(getActionableNode().isActive()) {
			ItemStack outputStack;
			IPackagePattern pattern;
			if(patternDetails instanceof PackageCraftingPatternDetails) {
				PackageCraftingPatternDetails details = (PackageCraftingPatternDetails)patternDetails;
				pattern = details.pattern;
				outputStack = pattern.getOutput();
			}
			else {
				outputStack = patternDetails.getOutputs().get(0).createItemStack();
				if(outputStack.getItem() instanceof IPackageItem) {
					IPackageItem packageItem = (IPackageItem)outputStack.getItem();
					IPackageRecipeInfo recipe = packageItem.getRecipeInfo(outputStack);
					int index = packageItem.getIndex(outputStack);
					if(recipe != null && recipe.validPatternIndex(index)) {
						pattern = recipe.getPatterns().get(index);
					}
					else {
						return false;
					}
				}
				else {
					return false;
				}
			}
			if(canPushPattern()) {
				ItemStack slotStack = itemHandler.getStackInSlot(9);
				if(slotStack.isEmpty() || slotStack.sameItem(outputStack) && ItemStack.tagMatches(slotStack, outputStack) && slotStack.getCount()+1 <= outputStack.getMaxStackSize()) {
					currentPattern = pattern;
					lockPattern = true;
					for(int i = 0; i < table.getContainerSize() && i < 9; ++i) {
						itemHandler.setStackInSlot(i, table.getItem(i).copy());
					}
					return true;
				}
			}
			for(BlockPos posP : BlockPos.betweenClosed(worldPosition.offset(-1, -1, -1), worldPosition.offset(1, 1, 1))) {
				TileEntity te = level.getBlockEntity(posP);
				if(te instanceof AEPackagerExtensionTile) {
					AEPackagerExtensionTile extension = (AEPackagerExtensionTile)te;
					if(extension.packager == this && extension.getActionableNode().isActive() && getActionableNode().getGrid() == extension.getActionableNode().getGrid() && extension.canPushPattern()) {
						ItemStack slotStack = extension.getItemHandler().getStackInSlot(9);
						if(slotStack.isEmpty() || slotStack.sameItem(outputStack) && ItemStack.tagMatches(slotStack, outputStack) && slotStack.getCount()+1 <= outputStack.getMaxStackSize()) {
							extension.currentPattern = pattern;
							extension.lockPattern = true;
							for(int i = 0; i < table.getContainerSize() && i < 9; ++i) {
								extension.getItemHandler().setStackInSlot(i, table.getItem(i).copy());
							}
							return true;
						}
					}
				}
			}
		}
		return false;
	}

	@Override
	public boolean isBusy() {
		if(canPushPattern()) {
			return false;
		}
		for(BlockPos posP : BlockPos.betweenClosed(worldPosition.offset(-1, -1, -1), worldPosition.offset(1, 1, 1))) {
			TileEntity te = level.getBlockEntity(posP);
			if(te instanceof AEPackagerExtensionTile) {
				AEPackagerExtensionTile extension = (AEPackagerExtensionTile)te;
				if(extension.packager == this && getActionableNode().getGrid() == extension.getActionableNode().getGrid() && extension.canPushPattern()) {
					return false;
				}
			}
		}
		return true;
	}

	@Override
	public void provideCrafting(ICraftingProviderHelper craftingTracker) {
		if(getActionableNode().isActive()) {
			for(IPackagePattern pattern : patternList) {
				craftingTracker.addCraftingOption(this, new PackageCraftingPatternDetails(pattern).toAEInternal(level));
			}
		}
	}

	@MENetworkEventSubscribe
	public void onChannelsChanged(MENetworkChannelsChanged event) {
		postPatternChange();
	}

	@MENetworkEventSubscribe
	public void onPowerStatusChange(MENetworkPowerStatusChange event) {
		postPatternChange();
	}

	@Override
	protected void ejectItem() {
		if(getActionableNode().isActive()) {
			IGrid grid = getActionableNode().getGrid();
			IStorageGrid storageGrid = grid.getCache(IStorageGrid.class);
			IEnergyGrid energyGrid = grid.getCache(IEnergyGrid.class);
			IItemStorageChannel storageChannel = Api.instance().storage().getStorageChannel(IItemStorageChannel.class);
			IMEMonitor<IAEItemStack> inventory = storageGrid.getInventory(storageChannel);
			IAEItemStack stack = storageChannel.createStack(itemHandler.getStackInSlot(9));
			IAEItemStack rem = Api.instance().storage().poweredInsert(energyGrid, inventory, stack, source, Actionable.MODULATE);
			if(rem == null || rem.getStackSize() == 0) {
				itemHandler.setStackInSlot(9, ItemStack.EMPTY);
			}
			else if(rem.getStackSize() < stack.getStackSize()) {
				itemHandler.setStackInSlot(9, rem.createItemStack());
			}
		}
		else {
			super.ejectItem();
		}
	}

	@Override
	public void postPatternChange() {
		if(getActionableNode().isActive()) {
			IGrid grid = getActionableNode().getGrid();
			grid.postEvent(new MENetworkCraftingPatternChange(this, getActionableNode()));
		}
	}

	protected void chargeMEEnergy() {
		if(getActionableNode().isActive()) {
			IGrid grid = getActionableNode().getGrid();
			IEnergyGrid energyGrid = grid.getCache(IEnergyGrid.class);
			double conversion = PowerUnits.RF.convertTo(PowerUnits.AE, 1);
			int request = Math.min(energyStorage.getMaxReceive(), energyStorage.getMaxEnergyStored()-energyStorage.getEnergyStored());
			double available = energyGrid.extractAEPower((request+0.5)*conversion, Actionable.SIMULATE, PowerMultiplier.CONFIG);
			int extract = (int)(available/conversion);
			energyGrid.extractAEPower(extract*conversion, Actionable.MODULATE, PowerMultiplier.CONFIG);
			energyStorage.receiveEnergy(extract, false);
		}
	}

	@Override
	public void load(BlockState blockState, CompoundNBT nbt) {
		super.load(blockState, nbt);
		if(nbt.contains("Node")) {
			getActionableNode().loadFromNBT("Node", nbt);
		}
	}

	@Override
	public CompoundNBT save(CompoundNBT nbt) {
		super.save(nbt);
		if(gridNode != null) {
			gridNode.saveToNBT("Node", nbt);
		}
		return nbt;
	}
}
