/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.gui;

import com.google.common.primitives.Longs;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import thelm.packagedauto.client.gui.GuiContainerTileBase;
import thelm.packagedauto.container.ContainerTileBase;

public abstract class GuiAmountSpecifying<C extends ContainerTileBase<?>>
extends GuiContainerTileBase<C> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/amount_specifying.png");
    private GuiContainerTileBase<?> parent;
    protected GuiTextField amountField;

    public GuiAmountSpecifying(GuiContainerTileBase<?> parent, C container) {
        super(container);
        this.field_146999_f = 172;
        this.field_147000_g = 99;
        this.parent = parent;
    }

    protected abstract int getDefaultAmount();

    protected abstract int getMaxAmount();

    protected abstract int[] getIncrements();

    protected abstract int[] getMultipliers();

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    public void func_73866_w_() {
        int multiplier;
        int increment;
        int i;
        this.field_146292_n.clear();
        super.func_73866_w_();
        this.field_146297_k.field_71439_g.field_71070_bA = this.parent.field_147002_h;
        this.func_189646_b(new ButtonSet(0, this.field_147003_i + 114, this.field_147009_r + 22, I18n.func_74838_a((String)"misc.packagedauto.set")));
        this.func_189646_b(new ButtonCancel(0, this.field_147003_i + 114, this.field_147009_r + 22 + 24, I18n.func_74838_a((String)"gui.cancel")));
        this.amountField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 9, this.field_147009_r + 51, 63, this.field_146289_q.field_78288_b);
        this.amountField.func_146185_a(false);
        this.amountField.func_146180_a(String.valueOf(this.getDefaultAmount()));
        this.amountField.func_146193_g(0xFFFFFF);
        this.amountField.func_175205_a(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int amount = Integer.parseInt(s);
                return amount >= 0 && amount <= this.getMaxAmount();
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        int[] increments = this.getIncrements();
        int[] multipliers = this.getMultipliers();
        int xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            multiplier = multipliers[i];
            this.func_189646_b(new ButtonAmount(i, increment, multiplier, this.field_147003_i + xx, this.field_147009_r + 20));
            xx += 34;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            multiplier = multipliers[i];
            this.func_189646_b(new ButtonAmount(i + 3, increment, multiplier, this.field_147003_i + xx, this.field_147009_r + this.field_147000_g - 20 - 7));
            xx += 34;
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.amountField.func_146194_f();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.amountField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.close();
            return;
        }
        if ((keyCode == 28 || keyCode == 156) && this.amountField.func_146206_l()) {
            this.onOkButtonPressed(GuiAmountSpecifying.func_146272_n());
            return;
        }
        if (this.amountField.func_146201_a(typedChar, keyCode)) {
            return;
        }
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode) && this.amountField.func_146206_l()) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof ButtonSet) {
            this.onOkButtonPressed(GuiAmountSpecifying.func_146272_n());
        }
        if (button instanceof ButtonCancel) {
            this.close();
        }
        if (button instanceof ButtonAmount) {
            this.onAmountButtonClicked(((ButtonAmount)button).increment, ((ButtonAmount)button).multiplier, button.field_146127_k >= 3, GuiAmountSpecifying.func_146272_n());
        }
    }

    protected void onAmountButtonClicked(int increment, int multiplier, boolean inverse, boolean shiftDown) {
        long oldAmount = 0L;
        try {
            oldAmount = Integer.parseInt(this.amountField.func_146179_b());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        long newAmount = !shiftDown ? (!inverse ? oldAmount + (long)increment : oldAmount - (long)increment) : (!inverse ? oldAmount * (long)multiplier : oldAmount / (long)multiplier);
        newAmount = Longs.constrainToRange((long)newAmount, (long)0L, (long)this.getMaxAmount());
        this.amountField.func_146180_a(String.valueOf(newAmount));
    }

    protected abstract void onOkButtonPressed(boolean var1);

    public void close() {
        this.field_146297_k.func_147108_a(this.parent);
    }

    public GuiContainerTileBase<?> getParent() {
        return this.parent;
    }

    static class ButtonAmount
    extends GuiButton {
        int increment;
        int multiplier;

        public ButtonAmount(int buttonId, int increment, int multiplier, int x, int y) {
            super(buttonId, x, y, 34, 20, "");
            this.increment = increment;
            this.multiplier = multiplier;
        }

        public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
            this.field_146126_j = !GuiScreen.func_146272_n() ? (this.field_146127_k < 3 ? "+" : "-") + this.increment : (this.field_146127_k < 3 ? "\u00d7" : "\u00f7") + this.multiplier;
            super.func_191745_a(mc, mouseX, mouseY, partialTicks);
        }
    }

    static class ButtonCancel
    extends GuiButton {
        public ButtonCancel(int buttonId, int x, int y, String text) {
            super(buttonId, x, y, 50, 20, text);
        }
    }

    static class ButtonSet
    extends GuiButton {
        public ButtonSet(int buttonId, int x, int y, String text) {
            super(buttonId, x, y, 50, 20, text);
        }
    }
}

