/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.integration.jei;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.reflect.Field;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.container.ContainerEncoder;
import thelm.packagedauto.network.PacketHandler;
import thelm.packagedauto.network.packet.PacketSetRecipe;

public class EncoderTransferHandler
implements IRecipeTransferHandler<ContainerEncoder> {
    private final IRecipeTransferHandlerHelper transferHelper;

    public EncoderTransferHandler(IRecipeTransferHandlerHelper transferHelper) {
        this.transferHelper = transferHelper;
    }

    public Class<ContainerEncoder> getContainerClass() {
        return ContainerEncoder.class;
    }

    public IRecipeTransferError transferRecipe(ContainerEncoder container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        IRecipeWrapper recipeWrapper;
        try {
            Field recipeField = recipeLayout.getClass().getDeclaredField("recipeWrapper");
            recipeField.setAccessible(true);
            recipeWrapper = (IRecipeWrapper)recipeField.get(recipeLayout);
        }
        catch (Exception e) {
            recipeWrapper = null;
        }
        String category = recipeLayout.getRecipeCategory().getUid();
        IRecipeType recipeType = container.patternInventory.recipeType;
        if (!recipeType.getJEICategories().contains(category)) {
            return this.transferHelper.createInternalError();
        }
        Int2ObjectMap<ItemStack> map = recipeType.getRecipeTransferMap(recipeWrapper, recipeLayout, category);
        if (map == null || map.isEmpty()) {
            return this.transferHelper.createInternalError();
        }
        if (!doTransfer) {
            return null;
        }
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketSetRecipe(map));
        return null;
    }
}

