/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.item;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import thelm.packagedauto.PackagedAuto;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeList;
import thelm.packagedauto.api.IRecipeListItem;
import thelm.packagedauto.client.IModelRegister;
import thelm.packagedauto.util.RecipeListHelper;

public class ItemRecipeHolder
extends Item
implements IRecipeListItem,
IModelRegister {
    public static final ItemRecipeHolder INSTANCE = new ItemRecipeHolder();
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation("packagedauto:recipe_holder#inventory");
    public static final ModelResourceLocation MODEL_LOCATION_FILLED = new ModelResourceLocation("packagedauto:recipe_holder_filled#inventory");

    public ItemRecipeHolder() {
        this.func_77655_b("packagedauto.recipe_holder");
        this.setRegistryName("packagedauto:recipe_holder");
        this.func_77637_a(PackagedAuto.CREATIVE_TAB);
    }

    @Override
    public IRecipeList getRecipeList(ItemStack stack) {
        return new RecipeListHelper(stack.func_77978_p());
    }

    @Override
    public void setRecipeList(ItemStack stack, IRecipeList recipeList) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_82580_o("Recipes");
        if (recipeList != null) {
            recipeList.writeToNBT(stack.func_77978_p());
        }
        if (stack.func_77978_p().func_82582_d()) {
            stack.func_77982_d(null);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af() && this.isFilled(playerIn.func_184586_b(handIn))) {
            ItemStack stack = playerIn.func_184586_b(handIn).func_77946_l();
            this.setRecipeList(stack, null);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            List<IRecipeInfo> recipeList = this.getRecipeList(stack).getRecipeList();
            tooltip.add(I18n.func_74838_a((String)"item.packagedauto.recipe_holder.recipes"));
            for (IRecipeInfo recipe : recipeList) {
                StringBuilder sb = new StringBuilder();
                sb.append(recipe.getRecipeType().getLocalizedName()).append(": ");
                List stackNames = recipe.getOutputs().stream().map(is -> is.func_190916_E() + " " + is.func_77946_l().func_82833_r()).collect(Collectors.toList());
                sb.append(StringUtils.abbreviate((String)StringUtils.join(stackNames, (String)", "), (int)64));
                tooltip.add(sb.toString());
            }
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean isFilled(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && !nbt.func_150295_c("Recipes", 10).func_82582_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> this.isFilled(stack) ? MODEL_LOCATION_FILLED : MODEL_LOCATION);
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{MODEL_LOCATION, MODEL_LOCATION_FILLED});
    }
}

