/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.network.ISelfHandleMessage;
import thelm.packagedauto.network.PacketHandler;

public class PacketBeam
implements ISelfHandleMessage<IMessage> {
    private Vec3d source;
    private List<Vec3d> deltas;
    private int color;
    private int lifetime;
    private boolean fadeout;

    public PacketBeam() {
    }

    public PacketBeam(Vec3d source, List<Vec3d> deltas, int color, int lifetime, boolean fadeout) {
        this.source = source;
        this.deltas = deltas;
        this.color = color;
        this.lifetime = lifetime;
        this.fadeout = fadeout;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.source.field_72450_a);
        buf.writeDouble(this.source.field_72448_b);
        buf.writeDouble(this.source.field_72449_c);
        buf.writeByte(this.deltas.size());
        for (Vec3d delta : this.deltas) {
            buf.writeDouble(delta.field_72450_a);
            buf.writeDouble(delta.field_72448_b);
            buf.writeDouble(delta.field_72449_c);
        }
        buf.writeMedium(this.color);
        buf.writeShort(this.lifetime);
        buf.writeBoolean(this.fadeout);
    }

    public void fromBytes(ByteBuf buf) {
        this.source = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        int size = buf.readByte();
        this.deltas = new ArrayList<Vec3d>(size);
        for (int i = 0; i < size; ++i) {
            this.deltas.add(new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }
        this.color = buf.readUnsignedMedium();
        this.lifetime = buf.readUnsignedShort();
        this.fadeout = buf.readBoolean();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> WorldOverlayRenderer.INSTANCE.addBeams(this.source, this.deltas, this.color, this.lifetime, this.fadeout));
        return null;
    }

    public static void sendBeams(Vec3d source, List<Vec3d> deltas, int color, int lifetime, boolean fadeout, int dimension, double range) {
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new PacketBeam(source, deltas, color, lifetime, fadeout), new NetworkRegistry.TargetPoint(dimension, source.field_72450_a, source.field_72448_b, source.field_72449_c, range));
    }

    public static void sendBeams(EntityPlayerMP player, Vec3d source, List<Vec3d> deltas, int color, int lifetime, boolean fadeout) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketBeam(source, deltas, color, lifetime, fadeout), player);
    }
}

