/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thelm.packagedauto.client.WorldOverlayRenderer;
import thelm.packagedauto.network.ISelfHandleMessage;
import thelm.packagedauto.network.PacketHandler;

public class PacketSizedMarker
implements ISelfHandleMessage<IMessage> {
    private Vec3d lowerCorner;
    private Vec3d size;
    private int color;
    private int lifetime;

    public PacketSizedMarker() {
    }

    public PacketSizedMarker(Vec3d lowerCorner, Vec3d size, int color, int lifetime) {
        this.lowerCorner = lowerCorner;
        this.size = size;
        this.color = color;
        this.lifetime = lifetime;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.lowerCorner.field_72450_a);
        buf.writeDouble(this.lowerCorner.field_72448_b);
        buf.writeDouble(this.lowerCorner.field_72449_c);
        buf.writeDouble(this.size.field_72450_a);
        buf.writeDouble(this.size.field_72448_b);
        buf.writeDouble(this.size.field_72449_c);
        buf.writeMedium(this.color);
        buf.writeShort(this.lifetime);
    }

    public void fromBytes(ByteBuf buf) {
        this.lowerCorner = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.size = new Vec3d(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.color = buf.readUnsignedMedium();
        this.lifetime = buf.readUnsignedShort();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(MessageContext ctx) {
        Minecraft.func_71410_x().func_152344_a(() -> WorldOverlayRenderer.INSTANCE.addSizedMarker(this.lowerCorner, this.size, this.color, this.lifetime));
        return null;
    }

    public static void sendSizedMarker(EntityPlayerMP player, Vec3d lowerCorner, Vec3d size, int color, int lifetime) {
        PacketHandler.INSTANCE.sendTo((IMessage)new PacketSizedMarker(lowerCorner, size, color, lifetime), player);
    }
}

