/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.tile;

import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.IActionHost;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import it.unimi.dsi.fastutil.booleans.BooleanListIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageItem;
import thelm.packagedauto.api.IPackagePattern;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeList;
import thelm.packagedauto.api.ISettingsCloneable;
import thelm.packagedauto.api.MiscUtil;
import thelm.packagedauto.client.gui.GuiUnpackager;
import thelm.packagedauto.container.ContainerUnpackager;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.integration.appeng.AppEngUtil;
import thelm.packagedauto.integration.appeng.networking.HostHelperTileUnpackager;
import thelm.packagedauto.integration.appeng.recipe.RecipeCraftingPatternHelper;
import thelm.packagedauto.inventory.InventoryUnpackager;
import thelm.packagedauto.item.ItemRecipeHolder;
import thelm.packagedauto.tile.TileBase;
import thelm.packagedauto.tile.TilePackager;
import thelm.packagedauto.tile.TilePackagerExtension;

@Optional.InterfaceList(value={@Optional.Interface(iface="appeng.api.networking.IGridHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.security.IActionHost", modid="appliedenergistics2"), @Optional.Interface(iface="appeng.api.networking.crafting.ICraftingProvider", modid="appliedenergistics2")})
public class TileUnpackager
extends TileBase
implements ITickable,
ISettingsCloneable,
IGridHost,
IActionHost,
ICraftingProvider {
    public static int energyCapacity = 5000;
    public static int energyUsage = 50;
    public static int refreshInterval = 4;
    public static boolean drawMEEnergy = true;
    public final PackageTracker[] trackers = new PackageTracker[10];
    public List<IRecipeInfo> recipeList = new ArrayList<IRecipeInfo>();
    public boolean powered = false;
    public boolean blocking = false;
    public int trackerCount = 6;
    public int roundRobinIndex = 0;
    public HostHelperTileUnpackager hostHelper;

    public TileUnpackager() {
        this.setInventory(new InventoryUnpackager(this));
        this.setEnergyStorage(new EnergyStorage(this, energyCapacity));
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i] = new PackageTracker();
        }
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            this.hostHelper = new HostHelperTileUnpackager(this);
        }
    }

    @Override
    protected String getLocalizedName() {
        return I18n.func_74838_a((String)"tile.packagedauto.unpackager.name");
    }

    @Override
    public String getConfigTypeName() {
        return "tile.packagedauto.unpackager.name";
    }

    public void onLoad() {
        this.updatePowered();
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.chargeEnergy();
            if (this.field_145850_b.func_82737_E() % (long)refreshInterval == 0L) {
                this.fillTrackers();
                this.emptyTrackers();
                if (drawMEEnergy && this.hostHelper != null && this.hostHelper.isActive()) {
                    this.hostHelper.chargeEnergy();
                }
            }
        }
    }

    protected void fillTrackers() {
        List emptyTrackers = Arrays.stream(this.trackers).limit(this.trackerCount).filter(t -> t.isEmpty()).collect(Collectors.toList());
        List nonEmptyTrackers = Arrays.stream(this.trackers).filter(t -> !t.isEmpty()).filter(t -> !t.isFilled()).collect(Collectors.toList());
        block0: for (int i = 0; i < 9; ++i) {
            ItemStack stack;
            if (this.energyStorage.getEnergyStored() < energyUsage || (stack = this.inventory.func_70301_a(i)).func_190926_b() || !(stack.func_77973_b() instanceof IPackageItem)) continue;
            IPackageItem packageItem = (IPackageItem)stack.func_77973_b();
            boolean flag = false;
            for (PackageTracker tracker : nonEmptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    flag = true;
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    break;
                }
                tracker.setRejectedIndex(i, true);
            }
            if (flag) continue;
            for (PackageTracker tracker : emptyTrackers) {
                if (tracker.tryAcceptPackage(packageItem, stack, i)) {
                    stack.func_190918_g(1);
                    if (stack.func_190926_b()) {
                        this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                    } else {
                        tracker.setRejectedIndex(i, true);
                    }
                    this.energyStorage.extractEnergy(energyUsage, false);
                    continue block0;
                }
                tracker.setRejectedIndex(i, true);
            }
        }
    }

    protected void emptyTrackers() {
        TileEntity tile;
        ArrayList directions = Lists.newArrayList((Object[])EnumFacing.field_82609_l);
        Collections.rotate(directions, this.roundRobinIndex);
        block0: for (EnumFacing facing : directions) {
            tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            if (!(tile instanceof IPackageCraftingMachine)) continue;
            IPackageCraftingMachine machine = (IPackageCraftingMachine)tile;
            for (PackageTracker tracker : this.trackers) {
                if (!tracker.isFilled() || tracker.recipe == null || !tracker.recipe.getRecipeType().hasMachine() || machine.isBusy() || !machine.acceptPackage(tracker.recipe, Lists.transform(tracker.recipe.getInputs(), ItemStack::func_77946_l), facing.func_176734_d())) continue;
                tracker.clearRecipe();
                this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                this.func_70296_d();
                continue block0;
            }
        }
        if (!this.powered) {
            directions = Lists.newArrayList((Object[])EnumFacing.field_82609_l);
            Collections.rotate(directions, this.roundRobinIndex);
            for (EnumFacing facing : directions) {
                PackageTracker trackerToEmpty;
                tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                if (!this.validSendTarget(tile, facing.func_176734_d()) || !tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) continue;
                IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                if (this.blocking && !MiscUtil.isEmpty(itemHandler) || (trackerToEmpty = (PackageTracker)Arrays.stream(this.trackers).filter(t -> t.isFilled() && t.facing == null && t.recipe != null && !t.recipe.getRecipeType().hasMachine()).findFirst().orElse(null)) == null) continue;
                if (trackerToEmpty.toSend.isEmpty()) {
                    trackerToEmpty.setupToSend();
                }
                boolean acceptsAll = true;
                for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                    ItemStack stack = trackerToEmpty.toSend.get(i);
                    ItemStack stackRem = MiscUtil.insertItem(itemHandler, stack, false, true);
                    acceptsAll &= stackRem.func_190916_E() < stack.func_190916_E();
                }
                trackerToEmpty.toSend.removeIf(ItemStack::func_190926_b);
                if (acceptsAll) {
                    trackerToEmpty.facing = facing;
                    this.roundRobinIndex = (this.roundRobinIndex + 1) % 6;
                }
                this.func_70296_d();
            }
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            TileEntity tile2 = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            PackageTracker trackerToEmpty = Arrays.stream(this.trackers).filter(t -> t.facing == facing).findFirst().orElse(null);
            if (trackerToEmpty == null) continue;
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.setupToSend();
            }
            boolean ordered = false;
            if (trackerToEmpty.recipe != null) {
                ordered = trackerToEmpty.recipe.getRecipeType().isOrdered();
            }
            if (!this.validSendTarget(tile2, facing.func_176734_d())) {
                trackerToEmpty.facing = null;
                continue;
            }
            if (!tile2.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
                trackerToEmpty.facing = null;
                continue;
            }
            IItemHandler itemHandler = (IItemHandler)tile2.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
            for (int i = 0; i < trackerToEmpty.toSend.size(); ++i) {
                ItemStack stack = trackerToEmpty.toSend.get(i);
                ItemStack stackRem = MiscUtil.insertItem(itemHandler, stack, ordered, false);
                trackerToEmpty.toSend.set(i, stackRem);
            }
            trackerToEmpty.toSend.removeIf(ItemStack::func_190926_b);
            if (trackerToEmpty.toSend.isEmpty()) {
                trackerToEmpty.clearRecipe();
            }
            this.func_70296_d();
        }
    }

    protected boolean validSendTarget(TileEntity tile, EnumFacing facing) {
        return tile != null && !(tile instanceof IPackageCraftingMachine) && !(tile instanceof TilePackager) && !(tile instanceof TilePackagerExtension) && !(tile instanceof TileUnpackager) && !this.isInterface(tile, facing.func_176734_d());
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.inventory.func_70301_a(10);
        if (energyStack.hasCapability(CapabilityEnergy.ENERGY, null)) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(((IEnergyStorage)energyStack.getCapability(CapabilityEnergy.ENERGY, null)).extractEnergy(energyRequest, false), false);
            if (energyStack.func_190916_E() <= 0) {
                this.inventory.func_70299_a(10, ItemStack.field_190927_a);
            }
        }
    }

    public void updatePowered() {
        if (this.field_145850_b.func_175687_A(this.field_174879_c) > 0 != this.powered) {
            this.powered = !this.powered;
            this.func_70296_d();
        }
    }

    @Override
    public int getComparatorSignal() {
        return Math.min((int)Arrays.stream(this.trackers).filter(t -> t.isFilled()).count(), 15);
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.hostHelper != null) {
            this.hostHelper.invalidate();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getGridNode(AEPartLocation dir) {
        return this.getActionableNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.SMART;
    }

    @Optional.Method(modid="appliedenergistics2")
    public void securityBreak() {
        this.field_145850_b.func_175655_b(this.field_174879_c, true);
    }

    @Optional.Method(modid="appliedenergistics2")
    public IGridNode getActionableNode() {
        return this.hostHelper.getNode();
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        if (this.hostHelper.isActive() && !this.isBusy() && patternDetails instanceof RecipeCraftingPatternHelper) {
            RecipeCraftingPatternHelper pattern = (RecipeCraftingPatternHelper)patternDetails;
            int energyReq = energyUsage * pattern.recipe.getPatterns().size();
            if (this.energyStorage.getEnergyStored() >= energyReq) {
                PackageTracker tracker = Arrays.stream(this.trackers).limit(this.trackerCount).filter(PackageTracker::isEmpty).findFirst().get();
                tracker.fillRecipe(pattern.recipe);
                this.energyStorage.extractEnergy(energyReq, false);
                return true;
            }
        }
        return false;
    }

    @Optional.Method(modid="appliedenergistics2")
    public boolean isBusy() {
        return Arrays.stream(this.trackers).limit(this.trackerCount).noneMatch(PackageTracker::isEmpty);
    }

    @Optional.Method(modid="appliedenergistics2")
    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        if (this.hostHelper.isActive()) {
            for (IRecipeInfo pattern : this.recipeList) {
                if (pattern.getOutputs().isEmpty()) continue;
                craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)new RecipeCraftingPatternHelper(pattern));
            }
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    @MENetworkEventSubscribe
    public void onChannelsChanged(MENetworkChannelsChanged event) {
        this.hostHelper.postPatternChange();
    }

    @Optional.Method(modid="appliedenergistics2")
    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange event) {
        this.hostHelper.postPatternChange();
    }

    protected boolean isInterface(TileEntity tile, EnumFacing facing) {
        if (Loader.isModLoaded((String)"appliedenergistics2")) {
            return AppEngUtil.isInterface(tile, facing);
        }
        return false;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public ISettingsCloneable.Result loadConfig(NBTTagCompound nbt, EntityPlayer player) {
        TextComponentTranslation message;
        block5: {
            this.blocking = nbt.func_74767_n("Blocking");
            this.trackerCount = nbt.func_74771_c("Trackers");
            message = null;
            if (nbt.func_74764_b("Recipes")) {
                if (this.inventory.func_70301_a(9).func_190926_b()) {
                    InventoryPlayer playerInventory = player.field_71071_by;
                    for (int i = 0; i < playerInventory.func_70302_i_(); ++i) {
                        ItemStack stack = playerInventory.func_70301_a(i);
                        if (stack.func_190926_b() || stack.func_77973_b() != ItemRecipeHolder.INSTANCE || stack.func_77942_o()) continue;
                        ItemStack stackCopy = stack.func_77979_a(1);
                        IRecipeList recipeListObj = ItemRecipeHolder.INSTANCE.getRecipeList(stackCopy);
                        List<IRecipeInfo> recipeList = MiscUtil.readRecipeListFromNBT(nbt.func_150295_c("Recipes", 10));
                        recipeListObj.setRecipeList(recipeList);
                        ItemRecipeHolder.INSTANCE.setRecipeList(stackCopy, recipeListObj);
                        this.inventory.func_70299_a(9, stackCopy);
                        break block5;
                    }
                    message = new TextComponentTranslation("tile.packagedauto.unpackager.no_holders", new Object[0]);
                } else {
                    message = new TextComponentTranslation("tile.packagedauto.unpackager.holder_present", new Object[0]);
                }
            }
        }
        if (message != null) {
            return ISettingsCloneable.Result.partial(message);
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public ISettingsCloneable.Result saveConfig(NBTTagCompound nbt, EntityPlayer player) {
        nbt.func_74757_a("Blocking", this.blocking);
        nbt.func_74774_a("Trackers", (byte)this.trackerCount);
        if (!this.recipeList.isEmpty()) {
            nbt.func_74782_a("Recipes", (NBTBase)MiscUtil.writeRecipeListToNBT(new NBTTagList(), this.recipeList));
        }
        return ISettingsCloneable.Result.success();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        if (this.hostHelper != null) {
            this.hostHelper.readFromNBT(nbt);
        }
        super.func_145839_a(nbt);
        this.blocking = nbt.func_74767_n("Blocking");
        this.trackerCount = nbt.func_74764_b("Trackers") ? (int)nbt.func_74771_c("Trackers") : 6;
        this.powered = nbt.func_74767_n("Powered");
        for (int i = 0; i < this.trackers.length; ++i) {
            this.trackers[i].readFromNBT(nbt.func_74775_l(String.format("Tracker%02d", i)));
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("Blocking", this.blocking);
        nbt.func_74774_a("Trackers", (byte)this.trackerCount);
        nbt.func_74757_a("Powered", this.powered);
        for (int i = 0; i < this.trackers.length; ++i) {
            NBTTagCompound subNBT = new NBTTagCompound();
            this.trackers[i].writeToNBT(subNBT);
            nbt.func_74782_a(String.format("Tracker%02d", i), (NBTBase)subNBT);
        }
        if (this.hostHelper != null) {
            this.hostHelper.writeToNBT(nbt);
        }
        return nbt;
    }

    public void changeBlockingMode() {
        this.blocking = !this.blocking;
        this.func_70296_d();
    }

    public void changeTrackerCount(boolean decrease) {
        this.trackerCount = MathHelper.func_76125_a((int)(this.trackerCount + (decrease ? -1 : 1)), (int)1, (int)10);
        this.func_70296_d();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getClientGuiElement(EntityPlayer player, Object ... args) {
        return new GuiUnpackager(new ContainerUnpackager(player.field_71071_by, this));
    }

    @Override
    public Container getServerGuiElement(EntityPlayer player, Object ... args) {
        return new ContainerUnpackager(player.field_71071_by, this);
    }

    public class PackageTracker {
        public boolean[] rejectedIndexes = new boolean[9];
        public IRecipeInfo recipe;
        public int amount;
        public BooleanList received = new BooleanArrayList();
        public List<ItemStack> toSend = new ArrayList<ItemStack>();
        public EnumFacing facing;

        public void clearRecipe() {
            this.clearRejectedIndexes();
            this.recipe = null;
            this.amount = 0;
            this.received.clear();
            this.facing = null;
            if (TileUnpackager.this.field_145850_b != null && !((TileUnpackager)TileUnpackager.this).field_145850_b.field_72995_K) {
                TileUnpackager.this.func_70296_d();
            }
        }

        public void fillRecipe(IRecipeInfo recipe) {
            this.recipe = recipe;
            this.amount = recipe.getPatterns().size();
            this.received.clear();
            this.received.size(this.amount);
            for (int i = 0; i < this.received.size(); ++i) {
                this.received.set(i, true);
            }
            if (TileUnpackager.this.field_145850_b != null && !((TileUnpackager)TileUnpackager.this).field_145850_b.field_72995_K) {
                TileUnpackager.this.func_70296_d();
            }
        }

        public void ejectItems() {
            if (TileUnpackager.this.field_145850_b != null && !this.isEmpty()) {
                if (!this.toSend.isEmpty()) {
                    for (ItemStack stack : this.toSend) {
                        if (stack.func_190926_b()) continue;
                        double dx = (double)(((TileUnpackager)TileUnpackager.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        double dy = (double)(((TileUnpackager)TileUnpackager.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.75;
                        double dz = (double)(((TileUnpackager)TileUnpackager.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        EntityItem entityitem = new EntityItem(TileUnpackager.this.field_145850_b, (double)TileUnpackager.this.field_174879_c.func_177958_n() + dx, (double)TileUnpackager.this.field_174879_c.func_177956_o() + dy, (double)TileUnpackager.this.field_174879_c.func_177952_p() + dz, stack);
                        entityitem.func_174869_p();
                        TileUnpackager.this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                } else {
                    List<IPackagePattern> patterns = this.recipe.getPatterns();
                    for (int i = 0; i < this.received.size() && i < patterns.size(); ++i) {
                        if (!this.received.getBoolean(i)) continue;
                        double dx = (double)(((TileUnpackager)TileUnpackager.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        double dy = (double)(((TileUnpackager)TileUnpackager.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.75;
                        double dz = (double)(((TileUnpackager)TileUnpackager.this).field_145850_b.field_73012_v.nextFloat() / 2.0f) + 0.25;
                        EntityItem entityitem = new EntityItem(TileUnpackager.this.field_145850_b, (double)TileUnpackager.this.field_174879_c.func_177958_n() + dx, (double)TileUnpackager.this.field_174879_c.func_177956_o() + dy, (double)TileUnpackager.this.field_174879_c.func_177952_p() + dz, patterns.get(i).getOutput());
                        entityitem.func_174869_p();
                        TileUnpackager.this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                }
                this.clearRecipe();
            }
        }

        public boolean tryAcceptPackage(IPackageItem packageItem, ItemStack stack, int invIndex) {
            if (this.rejectedIndexes[invIndex]) {
                return false;
            }
            IRecipeInfo recipe = packageItem.getRecipeInfo(stack);
            int index = packageItem.getIndex(stack);
            if (recipe != null && recipe.isValid() && recipe.validPatternIndex(index)) {
                if (this.recipe == null) {
                    this.recipe = recipe;
                    this.amount = recipe.getPatterns().size();
                    this.received.size(this.amount);
                    this.received.set(index, true);
                    TileUnpackager.this.func_70296_d();
                    return true;
                }
                if (this.recipe.equals(recipe) && !((Boolean)this.received.get(index)).booleanValue()) {
                    this.received.set(index, true);
                    TileUnpackager.this.func_70296_d();
                    return true;
                }
            }
            return false;
        }

        public void setRejectedIndex(int index, boolean rejected) {
            this.rejectedIndexes[index] = rejected;
        }

        public void clearRejectedIndexes() {
            Arrays.fill(this.rejectedIndexes, false);
        }

        public boolean isFilled() {
            if (!this.toSend.isEmpty()) {
                return true;
            }
            if (this.received.isEmpty()) {
                return false;
            }
            BooleanListIterator booleanListIterator = this.received.iterator();
            while (booleanListIterator.hasNext()) {
                boolean b = (Boolean)booleanListIterator.next();
                if (b) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            return this.recipe == null || !this.recipe.isValid();
        }

        public void setupToSend() {
            if (this.isEmpty() || this.recipe.getRecipeType().hasMachine() || !this.toSend.isEmpty()) {
                return;
            }
            this.toSend.addAll(Lists.transform(this.recipe.getInputs(), ItemStack::func_77946_l));
        }

        public void readFromNBT(NBTTagCompound nbt) {
            this.clearRecipe();
            NBTTagCompound tag = nbt.func_74775_l("Recipe");
            IRecipeInfo recipe = MiscUtil.readRecipeFromNBT(tag);
            if (recipe != null) {
                this.recipe = recipe;
                this.amount = nbt.func_74771_c("Amount");
                this.received.size(this.amount);
                byte[] receivedArray = nbt.func_74770_j("Received");
                for (int i = 0; i < this.received.size(); ++i) {
                    this.received.set(i, receivedArray[i] != 0);
                }
            }
            MiscUtil.loadAllItems(nbt.func_150295_c("ToSend", 10), this.toSend);
            if (nbt.func_74764_b("Facing")) {
                this.facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("Facing"));
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            if (this.recipe != null) {
                NBTTagCompound tag = MiscUtil.writeRecipeToNBT(new NBTTagCompound(), this.recipe);
                nbt.func_74782_a("Recipe", (NBTBase)tag);
                nbt.func_74774_a("Amount", (byte)this.amount);
                byte[] receivedArray = new byte[this.received.size()];
                for (int i = 0; i < this.received.size(); ++i) {
                    receivedArray[i] = (byte)(this.received.getBoolean(i) ? 1 : 0);
                }
                nbt.func_74773_a("Received", receivedArray);
            }
            nbt.func_74782_a("ToSend", (NBTBase)MiscUtil.saveAllItems(new NBTTagList(), this.toSend));
            if (this.facing != null) {
                nbt.func_74774_a("Facing", (byte)this.facing.func_176745_a());
            }
            return nbt;
        }

        public int getSyncValue() {
            int val = 0;
            for (int i = 0; i < this.received.size(); ++i) {
                if (!this.received.getBoolean(i)) continue;
                val |= 1 << i;
            }
            val <<= 4;
            return val |= this.amount;
        }

        public void setSyncValue(int val) {
            this.amount = val & 0xF;
            this.received.size(this.amount);
            val >>>= 4;
            for (int i = 0; i < this.received.size(); ++i) {
                this.received.set(i, (val >>> i & 1) != 0);
            }
        }
    }
}

