/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import thelm.packagedauto.api.IRecipeInfo;
import thelm.packagedauto.api.IRecipeList;
import thelm.packagedauto.api.MiscUtil;

public class RecipeListHelper
implements IRecipeList {
    private List<IRecipeInfo> recipeList = new ArrayList<IRecipeInfo>();

    public RecipeListHelper(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public RecipeListHelper(List<IRecipeInfo> recipeList) {
        this.setRecipeList(recipeList);
    }

    @Override
    public List<IRecipeInfo> getRecipeList() {
        return Collections.unmodifiableList(this.recipeList);
    }

    @Override
    public void setRecipeList(List<IRecipeInfo> recipeList) {
        this.recipeList.clear();
        this.recipeList.addAll(recipeList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.recipeList.clear();
        if (nbt != null) {
            this.recipeList.addAll(MiscUtil.readRecipeListFromNBT(nbt.func_150295_c("Recipes", 10)));
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagList tagList = MiscUtil.writeRecipeListToNBT(new NBTTagList(), this.recipeList);
        if (!tagList.func_82582_d()) {
            nbt.func_74782_a("Recipes", (NBTBase)tagList);
        }
        return nbt;
    }
}

