/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import thelm.packagedauto.api.DirectionalGlobalPos;
import thelm.packagedauto.client.RenderTimer;
import thelm.packagedauto.item.DistributorMarkerItem;
import thelm.packagedauto.item.ProxyMarkerItem;

public class WorldOverlayRenderer {
    public static final WorldOverlayRenderer INSTANCE = new WorldOverlayRenderer();
    public static final Vector3d BLOCK_SIZE = new Vector3d(1.0, 1.0, 1.0);
    private Minecraft mc;
    private List<DirectionalMarkerInfo> directionalMarkers = new LinkedList<DirectionalMarkerInfo>();
    private List<SizedMarkerInfo> sizedMarkers = new LinkedList<SizedMarkerInfo>();
    private List<BeamInfo> beams = new LinkedList<BeamInfo>();

    private WorldOverlayRenderer() {
    }

    public void onConstruct() {
        this.mc = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::onRenderWorldLast);
    }

    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.mc.field_71441_e == null || this.mc.field_71439_g == null || this.mc.func_147113_T()) {
            return;
        }
        for (Hand hand : Hand.values()) {
            DirectionalGlobalPos globalPos;
            ItemStack stack = this.mc.field_71439_g.func_184586_b(hand);
            if (stack.func_77973_b() == DistributorMarkerItem.INSTANCE && (globalPos = DistributorMarkerItem.INSTANCE.getDirectionalGlobalPos(stack)) != null) {
                this.addDirectionalMarkers(Collections.singletonList(globalPos), 65535, 1);
            }
            if (stack.func_77973_b() != ProxyMarkerItem.INSTANCE || (globalPos = ProxyMarkerItem.INSTANCE.getDirectionalGlobalPos(stack)) == null) continue;
            this.addDirectionalMarkers(Collections.singletonList(globalPos), 0xFF7F00, 1);
        }
    }

    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.render(event.getMatrixStack(), event.getPartialTicks());
    }

    public void addDirectionalMarkers(List<DirectionalGlobalPos> positions, int color, int lifetime) {
        this.directionalMarkers.add(new DirectionalMarkerInfo(positions, color, lifetime));
    }

    public void addSizedMarker(Vector3d lowerCorner, Vector3d size, int color, int lifetime) {
        this.sizedMarkers.add(new SizedMarkerInfo(lowerCorner, size, color, lifetime));
    }

    public void addBeams(Vector3d source, List<Vector3d> deltas, int color, int lifetime, boolean fadeout) {
        this.beams.add(new BeamInfo(source, deltas, color, lifetime, fadeout));
    }

    public void render(MatrixStack matrixStack, float partialTick) {
        int g;
        int r;
        int currentTick = RenderTimer.INSTANCE.getTicks();
        this.directionalMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.sizedMarkers.removeIf(marker -> marker.shouldRemove(currentTick));
        this.beams.removeIf(beam -> beam.shouldRemove(currentTick));
        float renderTick = (float)currentTick + partialTick;
        Vector3d cameraPos = this.mc.field_71460_t.func_215316_n().func_216785_c();
        IRenderTypeBuffer.Impl buffers = RenderTypeHelper.BUFFERS;
        IVertexBuilder quadBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_QUAD);
        IVertexBuilder lineBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_LINE_4);
        for (DirectionalMarkerInfo directionalMarkerInfo : this.directionalMarkers) {
            int r2 = directionalMarkerInfo.color >> 16 & 0xFF;
            int g2 = directionalMarkerInfo.color >> 8 & 0xFF;
            int b = directionalMarkerInfo.color & 0xFF;
            for (DirectionalGlobalPos globalPos : directionalMarkerInfo.positions) {
                if (!globalPos.dimension().equals((Object)this.mc.field_71441_e.func_234923_W_())) continue;
                int range = 64;
                BlockPos blockPos = globalPos.blockPos();
                Vector3d distVec = cameraPos.func_178788_d(Vector3d.func_237489_a_((Vector3i)blockPos));
                if (Doubles.max((double[])new double[]{Math.abs(distVec.field_72450_a), Math.abs(distVec.field_72448_b), Math.abs(distVec.field_72449_c)}) > (double)range) continue;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)blockPos.func_177958_n() - cameraPos.field_72450_a, (double)blockPos.func_177956_o() - cameraPos.field_72448_b, (double)blockPos.func_177952_p() - cameraPos.field_72449_c);
                Direction direction = globalPos.direction();
                this.addMarkerVertices(matrixStack, quadBuffer, BLOCK_SIZE, direction, r2, g2, b, 127);
                this.addMarkerVertices(matrixStack, lineBuffer, BLOCK_SIZE, null, r2, g2, b, 255);
                matrixStack.func_227865_b_();
            }
        }
        RenderSystem.disableDepthTest();
        buffers.func_228461_a_();
        RenderSystem.enableDepthTest();
        lineBuffer = buffers.getBuffer(RenderTypeHelper.MARKER_LINE_4);
        for (SizedMarkerInfo sizedMarkerInfo : this.sizedMarkers) {
            Vector3d lowerCorner = sizedMarkerInfo.lowerCorner;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(lowerCorner.field_72450_a - cameraPos.field_72450_a, lowerCorner.field_72448_b - cameraPos.field_72448_b, lowerCorner.field_72449_c - cameraPos.field_72449_c);
            r = sizedMarkerInfo.color >> 16 & 0xFF;
            g = sizedMarkerInfo.color >> 8 & 0xFF;
            int b = sizedMarkerInfo.color & 0xFF;
            this.addMarkerVertices(matrixStack, lineBuffer, sizedMarkerInfo.size, null, r, g, b, 255);
            matrixStack.func_227865_b_();
        }
        buffers.func_228461_a_();
        lineBuffer = buffers.getBuffer(RenderTypeHelper.BEAM_LINE_3);
        for (BeamInfo beamInfo : this.beams) {
            Vector3d source = beamInfo.source;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(source.field_72450_a - cameraPos.field_72450_a, source.field_72448_b - cameraPos.field_72448_b, source.field_72449_c - cameraPos.field_72449_c);
            r = beamInfo.color >> 16 & 0xFF;
            g = beamInfo.color >> 8 & 0xFF;
            int b = beamInfo.color & 0xFF;
            int a = (int)(beamInfo.getAlpha(renderTick) * 255.0f);
            for (Vector3d delta : beamInfo.deltas) {
                this.addBeamVertices(matrixStack, lineBuffer, delta, r, g, b, a);
            }
            matrixStack.func_227865_b_();
        }
        buffers.func_228461_a_();
    }

    public void addMarkerVertices(MatrixStack matrixStack, IVertexBuilder buffer, Vector3d delta, Direction direction, int r, int g, int b, int a) {
        Matrix4f pose = matrixStack.func_227866_c_().func_227870_a_();
        float x = (float)delta.field_72450_a;
        float y = (float)delta.field_72448_b;
        float z = (float)delta.field_72449_c;
        if (direction == null || direction == Direction.NORTH) {
            buffer.func_227888_a_(pose, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == Direction.SOUTH) {
            buffer.func_227888_a_(pose, x, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, y, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, z).func_225586_a_(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == Direction.WEST) {
            buffer.func_227888_a_(pose, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, y, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        }
        if (direction == null || direction == Direction.EAST) {
            buffer.func_227888_a_(pose, x, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, z).func_225586_a_(r, g, b, a).func_181675_d();
        }
        if (direction == Direction.DOWN) {
            buffer.func_227888_a_(pose, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
        }
        if (direction == Direction.UP) {
            buffer.func_227888_a_(pose, 0.0f, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, y, z).func_225586_a_(r, g, b, a).func_181675_d();
        }
        if (direction == null) {
            buffer.func_227888_a_(pose, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, x, y, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, y, z).func_225586_a_(r, g, b, a).func_181675_d();
            buffer.func_227888_a_(pose, 0.0f, 0.0f, z).func_225586_a_(r, g, b, a).func_181675_d();
        }
    }

    public void addBeamVertices(MatrixStack matrixStack, IVertexBuilder buffer, Vector3d delta, int r, int g, int b, int a) {
        Matrix4f pose = matrixStack.func_227866_c_().func_227870_a_();
        float x = (float)delta.field_72450_a;
        float y = (float)delta.field_72448_b;
        float z = (float)delta.field_72449_c;
        buffer.func_227888_a_(pose, 0.0f, 0.0f, 0.0f).func_225586_a_(r, g, b, a).func_181675_d();
        buffer.func_227888_a_(pose, x, y, z).func_225586_a_(r, g, b, a).func_181675_d();
    }

    public static class RenderTypeHelper
    extends RenderType {
        public static final RenderType MARKER_LINE_4 = RenderTypeHelper.func_228633_a_((String)"packagedauto:marker_line_4", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)8192, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(4.0))).func_228718_a_(field_239235_M_).func_228727_a_(field_228496_F_).func_228715_a_(field_228492_B_).func_228714_a_(field_228491_A_).func_228728_a_(false));
        public static final RenderType MARKER_QUAD = RenderTypeHelper.func_228633_a_((String)"packagedauto:marker_quad", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)7, (int)1024, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228718_a_(field_239235_M_).func_228726_a_(field_228515_g_).func_228727_a_(field_228496_F_).func_228715_a_(field_228492_B_).func_228714_a_(field_228491_A_).func_228728_a_(false));
        public static final RenderType BEAM_LINE_3 = RenderTypeHelper.func_228633_a_((String)"packagedauto:beam_line_3", (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)8192, (boolean)false, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(3.0))).func_228718_a_(field_239235_M_).func_228726_a_(field_228515_g_).func_228721_a_(field_241712_U_).func_228727_a_(field_228495_E_).func_228714_a_(field_228491_A_).func_228728_a_(false));
        public static final IRenderTypeBuffer.Impl BUFFERS = IRenderTypeBuffer.func_228456_a_((Map)ImmutableMap.of((Object)MARKER_LINE_4, (Object)new BufferBuilder(MARKER_LINE_4.func_228662_o_()), (Object)MARKER_QUAD, (Object)new BufferBuilder(MARKER_QUAD.func_228662_o_()), (Object)BEAM_LINE_3, (Object)new BufferBuilder(BEAM_LINE_3.func_228662_o_())), (BufferBuilder)Tessellator.func_178181_a().func_178180_c());

        private RenderTypeHelper(String name, VertexFormat format, int mode, int bufferSize, boolean affectsCrumbling, boolean sortOnUpload, Runnable setupState, Runnable clearState) {
            super(name, format, mode, bufferSize, affectsCrumbling, sortOnUpload, setupState, clearState);
        }
    }

    public static class BeamInfo {
        private Vector3d source;
        private List<Vector3d> deltas;
        private int color;
        private int lifetime;
        private int startTick;
        private boolean fadeout;

        public BeamInfo(Vector3d source, List<Vector3d> deltas, int color, int lifetime, boolean fadeout) {
            this.source = source;
            this.deltas = deltas;
            this.color = color;
            this.lifetime = lifetime;
            this.fadeout = fadeout;
            this.startTick = RenderTimer.INSTANCE.getTicks();
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }

        public float getAlpha(float renderTick) {
            if (!this.fadeout) {
                return 1.0f;
            }
            float diff = renderTick - (float)this.startTick;
            if (diff < 0.0f) {
                diff += 2097151.0f;
            }
            float factor = Math.min(diff / (float)this.lifetime, 1.0f);
            return 1.0f - factor * factor;
        }
    }

    public static class SizedMarkerInfo {
        private Vector3d lowerCorner;
        private Vector3d size;
        private int color;
        private int lifetime;
        private int startTick;

        public SizedMarkerInfo(Vector3d lowerCorner, Vector3d size, int color, int lifetime) {
            this.lowerCorner = lowerCorner;
            this.size = size;
            this.color = color;
            this.lifetime = lifetime;
            this.startTick = RenderTimer.INSTANCE.getTicks();
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }

    public static class DirectionalMarkerInfo {
        private List<DirectionalGlobalPos> positions;
        private int color;
        private int lifetime;
        private int startTick;

        public DirectionalMarkerInfo(List<DirectionalGlobalPos> positions, int color, int lifetime) {
            this.positions = positions;
            this.color = color;
            this.lifetime = lifetime;
            this.startTick = RenderTimer.INSTANCE.getTicks();
        }

        public boolean shouldRemove(int currentTick) {
            if (currentTick < this.startTick) {
                currentTick += 0x1FFFFF;
            }
            return currentTick - this.startTick >= this.lifetime;
        }
    }
}

