/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import thelm.packagedauto.client.screen.BaseScreen;
import thelm.packagedauto.container.BaseContainer;

public abstract class AmountSpecifyingScreen<C extends BaseContainer<?>>
extends BaseScreen<C> {
    public static final ResourceLocation BACKGROUND = new ResourceLocation("packagedauto:textures/gui/amount_specifying.png");
    private BaseScreen<?> parent;
    protected TextFieldWidget amountField;

    public AmountSpecifyingScreen(BaseScreen<?> parent, C container, PlayerInventory playerInventory, ITextComponent title) {
        super(container, playerInventory, title);
        this.field_146999_f = 172;
        this.field_147000_g = 99;
        this.parent = parent;
    }

    protected abstract int getDefaultAmount();

    protected abstract int getMaxAmount();

    protected abstract int[] getIncrements();

    @Override
    protected ResourceLocation getBackgroundTexture() {
        return BACKGROUND;
    }

    protected void func_231160_c_() {
        String text;
        int increment;
        int i;
        this.field_230710_m_.clear();
        super.func_231160_c_();
        this.func_230480_a_(new ButtonSet(this.field_147003_i + 114, this.field_147009_r + 22, (ITextComponent)new TranslationTextComponent("misc.packagedauto.set")));
        this.func_230480_a_(new ButtonCancel(this.field_147003_i + 114, this.field_147009_r + 22 + 24, (ITextComponent)new TranslationTextComponent("gui.cancel")));
        this.field_230712_o_.getClass();
        this.amountField = new TextFieldWidget(this.field_230712_o_, this.field_147003_i + 9, this.field_147009_r + 51, 63, 9, StringTextComponent.field_240750_d_);
        this.amountField.func_146185_a(false);
        this.amountField.func_146180_a(String.valueOf(this.getDefaultAmount()));
        this.amountField.func_146193_g(0xFFFFFF);
        this.amountField.func_200675_a(s -> {
            if (s.isEmpty()) {
                return true;
            }
            try {
                int amount = Integer.parseInt(s);
                return amount >= 0 && amount <= this.getMaxAmount();
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.func_230480_a_((Widget)this.amountField);
        int[] increments = this.getIncrements();
        int xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "+" + increment;
            this.func_230480_a_(new ButtonIncrement(increment, this.field_147003_i + xx, this.field_147009_r + 20, (ITextComponent)new StringTextComponent(text)));
            xx += 34;
        }
        xx = 7;
        for (i = 0; i < 3; ++i) {
            increment = increments[i];
            text = "-" + increment;
            this.func_230480_a_(new ButtonIncrement(-increment, this.field_147003_i + xx, this.field_147009_r + this.field_147000_g - 20 - 7, (ITextComponent)new StringTextComponent(text)));
            xx += 34;
        }
    }

    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        super.func_230450_a_(matrixStack, partialTicks, mouseX, mouseY);
        this.amountField.func_230431_b_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        this.field_230712_o_.func_238421_b_(matrixStack, this.func_231171_q_().getString(), 7.0f, 7.0f, 0x404040);
    }

    public boolean func_231046_a_(int key, int scanCode, int modifiers) {
        if (key == 256) {
            this.close();
            return true;
        }
        if ((key == 257 || key == 335) && this.amountField.func_230999_j_()) {
            this.onOkButtonPressed(AmountSpecifyingScreen.func_231173_s_());
            return true;
        }
        if (this.amountField.func_231046_a_(key, scanCode, modifiers)) {
            return true;
        }
        InputMappings.Input mouseKey = InputMappings.func_197954_a((int)key, (int)scanCode);
        if (this.field_230706_i_.field_71474_y.field_151445_Q.isActiveAndMatches(mouseKey) && this.amountField.func_230999_j_()) {
            return true;
        }
        return super.func_231046_a_(key, scanCode, modifiers);
    }

    protected void onIncrementButtonClicked(int increment) {
        int oldAmount = 0;
        try {
            oldAmount = Integer.parseInt(this.amountField.func_146179_b());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int newAmount = MathHelper.func_76125_a((int)(oldAmount + increment), (int)0, (int)this.getMaxAmount());
        this.amountField.func_146180_a(String.valueOf(newAmount));
    }

    protected abstract void onOkButtonPressed(boolean var1);

    public void close() {
        this.field_230706_i_.func_147108_a(this.parent);
    }

    public BaseScreen<?> getParent() {
        return this.parent;
    }

    class ButtonIncrement
    extends Widget {
        int increment;

        public ButtonIncrement(int increment, int x, int y, ITextComponent text) {
            super(x, y, 34, 20, text);
            this.increment = increment;
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            AmountSpecifyingScreen.this.onIncrementButtonClicked(this.increment);
        }
    }

    class ButtonCancel
    extends Widget {
        public ButtonCancel(int x, int y, ITextComponent text) {
            super(x, y, 50, 20, text);
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            AmountSpecifyingScreen.this.close();
        }
    }

    class ButtonSet
    extends Widget {
        public ButtonSet(int x, int y, ITextComponent text) {
            super(x, y, 50, 20, text);
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            AmountSpecifyingScreen.this.onOkButtonPressed(Screen.func_231173_s_());
        }
    }
}

