/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedauto.container;

import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIntArray;
import net.minecraft.util.math.BlockPos;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.slot.FalseCopySlot;
import thelm.packagedauto.tile.BaseTile;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedauto.util.OptionalIntReferenceHolder;

public class BaseContainer<T extends BaseTile>
extends Container {
    public final T tile;
    public final PlayerInventory playerInventory;
    public final BaseItemHandler<?> itemHandler;

    public BaseContainer(ContainerType<?> containerType, int windowId, PlayerInventory playerInventory, T tile) {
        super(containerType, windowId);
        this.tile = tile;
        this.playerInventory = playerInventory;
        this.itemHandler = tile != null ? ((BaseTile)((Object)tile)).getItemHandler() : new BaseItemHandler<Object>(null, 0);
        this.func_216961_a(this.itemHandler);
    }

    public int getPlayerInvX() {
        return 8;
    }

    public int getPlayerInvY() {
        return 84;
    }

    protected void setupPlayerInventory() {
        int i;
        int xOffset = this.getPlayerInvX();
        int yOffset = this.getPlayerInvY();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, j + i * 9 + 9, xOffset + j * 18, yOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, i, xOffset + i * 18, yOffset + 58));
        }
    }

    protected void func_216961_a(IIntArray array) {
        for (int i = 0; i < array.func_221478_a(); ++i) {
            this.func_216958_a(OptionalIntReferenceHolder.of(array, i));
        }
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean supportsShiftClick(PlayerEntity player, int slotIndex) {
        return true;
    }

    public boolean performMerge(PlayerEntity player, int slotIndex, ItemStack stack) {
        int invBase = this.getContainerSize();
        int invFull = this.field_75151_b.size();
        if (slotIndex < invBase) {
            return this.func_75135_a(stack, invBase, invFull, true);
        }
        return this.func_75135_a(stack, 0, invBase, false);
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        if (!this.supportsShiftClick(player, slotIndex)) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            stack = stackInSlot.func_77946_l();
            if (!this.performMerge(player, slotIndex, stackInSlot)) {
                return ItemStack.field_190927_a;
            }
            slot.func_75220_a(stackInSlot, stack);
            if (stackInSlot.func_190916_E() <= 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75215_d(stackInSlot);
            }
            if (stackInSlot.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, stackInSlot);
        }
        return stack;
    }

    protected boolean func_75135_a(ItemStack stack, int slotMin, int slotMax, boolean ascending) {
        int maxStack;
        int rmv;
        ItemStack existingStack;
        Slot slot;
        int iterOrder;
        boolean successful = false;
        int i = !ascending ? slotMin : slotMax - 1;
        int n = iterOrder = !ascending ? 1 : -1;
        if (stack.func_77985_e()) {
            while (stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.field_75151_b.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.func_75211_c();
                if (!existingStack.func_190926_b() && slot.func_75214_a(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.func_190916_E()))) && existingStack.func_77973_b().equals(stack.func_77973_b()) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)existingStack)) {
                    int existingSize = existingStack.func_190916_E() + stack.func_190916_E();
                    if (existingSize <= maxStack) {
                        stack.func_190920_e(0);
                        existingStack.func_190920_e(existingSize);
                        slot.func_75215_d(existingStack);
                        successful = true;
                    } else if (existingStack.func_190916_E() < maxStack) {
                        stack.func_190918_g(maxStack - existingStack.func_190916_E());
                        existingStack.func_190920_e(maxStack);
                        slot.func_75215_d(existingStack);
                        successful = true;
                    }
                }
                i += iterOrder;
            }
        }
        if (stack.func_190916_E() > 0) {
            int n2 = i = !ascending ? slotMin : slotMax - 1;
            while (stack.func_190916_E() > 0 && (!ascending && i < slotMax || ascending && i >= slotMin)) {
                slot = (Slot)this.field_75151_b.get(i);
                if (slot instanceof FalseCopySlot) {
                    i += iterOrder;
                    continue;
                }
                existingStack = slot.func_75211_c();
                if (existingStack.func_190926_b() && slot.func_75214_a(MiscHelper.INSTANCE.cloneStack(stack, rmv = Math.min(maxStack = Math.min(stack.func_77976_d(), slot.func_75219_a()), stack.func_190916_E())))) {
                    existingStack = stack.func_77979_a(rmv);
                    slot.func_75215_d(existingStack);
                    successful = true;
                }
                i += iterOrder;
            }
        }
        return successful;
    }

    public ItemStack func_184996_a(int slotId, int mouseButton, ClickType clickType, PlayerEntity player) {
        Slot slot;
        if (slotId >= 0 && (slot = (Slot)this.field_75151_b.get(slotId)) instanceof FalseCopySlot) {
            if (clickType == ClickType.QUICK_MOVE) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                ItemStack toPut = player.field_71071_by.func_70445_o().func_77946_l();
                ItemStack stack = slot.func_75211_c().func_77946_l();
                switch (mouseButton) {
                    case 0: {
                        slot.func_75215_d(toPut);
                        break;
                    }
                    case 1: {
                        if (stack.func_190926_b()) {
                            if (!toPut.func_190926_b()) {
                                toPut.func_190920_e(1);
                            }
                            slot.func_75215_d(toPut);
                            break;
                        }
                        if (stack.func_77969_a(toPut) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)toPut) && stack.func_190916_E() < stack.func_77976_d()) {
                            stack.func_190917_f(1);
                            slot.func_75215_d(stack);
                            break;
                        }
                        stack.func_190918_g(1);
                        slot.func_75215_d(stack);
                    }
                }
            }
            return player.field_71071_by.func_70445_o();
        }
        return super.func_184996_a(slotId, mouseButton, clickType, player);
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (this.tile != null) {
            BlockPos pos = this.tile.func_174877_v();
            return this.tile.func_145831_w().func_175625_s(pos) == this.tile && this.tile.func_174877_v().func_218138_a((IPosition)player.func_213303_ch(), true) <= 64.0;
        }
        return true;
    }
}

